/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class AzureAccountKeyCredential
implements Credential {
    public static final String AZURE_ACCOUNT_KEY_CREDENTIAL_TYPE = "azure-account-key";
    public static final String GRAVITINO_AZURE_STORAGE_ACCOUNT_NAME = "azure-storage-account-name";
    public static final String GRAVITINO_AZURE_STORAGE_ACCOUNT_KEY = "azure-storage-account-key";
    private String accountName;
    private String accountKey;

    public AzureAccountKeyCredential(String accountName, String accountKey) {
        this.validate(accountName, accountKey);
        this.accountName = accountName;
        this.accountKey = accountKey;
    }

    public AzureAccountKeyCredential() {
    }

    @Override
    public String credentialType() {
        return AZURE_ACCOUNT_KEY_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return 0L;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder<String, String>().put(GRAVITINO_AZURE_STORAGE_ACCOUNT_NAME, this.accountName).put(GRAVITINO_AZURE_STORAGE_ACCOUNT_KEY, this.accountKey).build();
    }

    @Override
    public void initialize(Map<String, String> credentialInfo, long expireTimeInMS) {
        String accountName = credentialInfo.get(GRAVITINO_AZURE_STORAGE_ACCOUNT_NAME);
        String accountKey = credentialInfo.get(GRAVITINO_AZURE_STORAGE_ACCOUNT_KEY);
        this.validate(accountName, accountKey);
        this.accountName = accountName;
        this.accountKey = accountKey;
    }

    public String accountName() {
        return this.accountName;
    }

    public String accountKey() {
        return this.accountKey;
    }

    private void validate(String accountName, String accountKey) {
        Preconditions.checkArgument(StringUtils.isNotBlank(accountName), "Azure account name should not be empty.");
        Preconditions.checkArgument(StringUtils.isNotBlank(accountKey), "Azure account key should not be empty.");
    }
}

