/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.ManagedSchemaOperations;
import org.apache.gravitino.catalog.model.ModelImpl;
import org.apache.gravitino.catalog.model.ModelVersionImpl;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchModelVersionURINameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class ModelCatalogOperations
extends ManagedSchemaOperations
implements CatalogOperations,
ModelCatalog {
    private static final int INIT_VERSION = 0;
    private final EntityStore store;

    public ModelCatalogOperations(EntityStore store) {
        this.store = store;
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
    }

    public void close() throws IOException {
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
    }

    protected EntityStore store() {
        return this.store;
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        NamespaceUtil.checkModel((Namespace)namespace);
        try {
            List models = this.store.list(namespace, ModelEntity.class, Entity.EntityType.MODEL);
            return (NameIdentifier[])models.stream().map(m -> NameIdentifier.of((Namespace)namespace, (String)m.name())).toArray(NameIdentifier[]::new);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException((Throwable)e, "Schema %s does not exist", new Object[]{namespace});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to list models under namespace " + String.valueOf(namespace), ioe);
        }
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        try {
            ModelEntity model = (ModelEntity)this.store.get(ident, Entity.EntityType.MODEL, ModelEntity.class);
            return this.toModelImpl(model);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get model " + String.valueOf(ident), ioe);
        }
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws ModelAlreadyExistsException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property string identifier should not be null");
        ModelEntity model = ModelEntity.builder().withId(Long.valueOf(stringId.id())).withName(ident.name()).withNamespace(ident.namespace()).withComment(comment).withProperties(properties).withLatestVersion(Integer.valueOf(0)).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)model, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to register model " + String.valueOf(ident), e);
        }
        catch (EntityAlreadyExistsException e) {
            throw new ModelAlreadyExistsException((Throwable)e, "Model %s already exists", new Object[]{ident});
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException((Throwable)e, "Schema %s does not exist", new Object[]{ident.namespace()});
        }
        return this.toModelImpl(model);
    }

    public boolean deleteModel(NameIdentifier ident) {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        try {
            return this.store.delete(ident, Entity.EntityType.MODEL);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete model " + String.valueOf(ident), ioe);
        }
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        Namespace modelVersionNs = NamespaceUtil.toModelVersionNs((NameIdentifier)ident);
        try {
            List versions = this.store.list(modelVersionNs, ModelVersionEntity.class, Entity.EntityType.MODEL_VERSION);
            return versions.stream().mapToInt(ModelVersionEntity::version).toArray();
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to list model versions for model " + String.valueOf(ident), ioe);
        }
    }

    public ModelVersion[] listModelVersionInfos(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        Namespace modelVersionNs = NamespaceUtil.toModelVersionNs((NameIdentifier)ident);
        try {
            List versions = this.store.list(modelVersionNs, ModelVersionEntity.class, Entity.EntityType.MODEL_VERSION);
            return (ModelVersion[])versions.stream().map(this::toModelVersionImpl).toArray(ModelVersion[]::new);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to list model version infos for model " + String.valueOf(ident), ioe);
        }
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (int)version);
        return this.internalGetModelVersion(modelVersionIdent);
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (String)alias);
        return this.internalGetModelVersion(modelVersionIdent);
    }

    public void linkModelVersion(NameIdentifier ident, Map<String, String> uris, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property string identifier should not be null");
        ArrayList aliasList = aliases == null ? Lists.newArrayList() : Lists.newArrayList((Object[])aliases);
        ModelVersionEntity modelVersion = ModelVersionEntity.builder().withModelIdentifier(ident).withVersion(0).withAliases((List)aliasList).withUris(uris).withComment(comment).withProperties(properties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)modelVersion, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to link model version " + String.valueOf(ident), e);
        }
        catch (EntityAlreadyExistsException e) {
            throw new ModelVersionAliasesAlreadyExistException((Throwable)e, "Model version alias already exists in %s", new Object[]{ident});
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
    }

    public String getModelVersionUri(NameIdentifier ident, int version, String uriName) throws NoSuchModelVersionException, NoSuchModelVersionURINameException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (int)version);
        return this.internalGetModelVersionUri(ident, modelVersionIdent, Optional.ofNullable(uriName));
    }

    public String getModelVersionUri(NameIdentifier ident, String alias, String uriName) throws NoSuchModelVersionException, NoSuchModelVersionURINameException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (String)alias);
        return this.internalGetModelVersionUri(ident, modelVersionIdent, Optional.ofNullable(uriName));
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (int)version);
        return this.internalDeleteModelVersion(modelVersionIdent);
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (String)alias);
        return this.internalDeleteModelVersion(modelVersionIdent);
    }

    public Model alterModel(NameIdentifier ident, ModelChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        try {
            if (!this.store.exists(ident, Entity.EntityType.MODEL)) {
                throw new NoSuchModelException("Model %s does not exist", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to alter model " + String.valueOf(ident), ioe);
        }
        try {
            ModelEntity updatedModelEntity = (ModelEntity)this.store.update(ident, ModelEntity.class, Entity.EntityType.MODEL, e -> this.updateModelEntity(ident, (ModelEntity)e, changes));
            return this.toModelImpl(updatedModelEntity);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load model " + String.valueOf(ident), ioe);
        }
        catch (NoSuchEntityException nsee) {
            throw new NoSuchModelException((Throwable)nsee, "Model %s does not exist", new Object[]{ident});
        }
        catch (EntityAlreadyExistsException eaee) {
            throw new RuntimeException("Model already exist " + ident.name(), eaee);
        }
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, int version, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (int)version);
        return this.internalUpdateModelVersion(modelVersionIdent, changes);
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, String alias, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (String)alias);
        return this.internalUpdateModelVersion(modelVersionIdent, changes);
    }

    private ModelEntity updateModelEntity(NameIdentifier ident, ModelEntity modelEntity, ModelChange ... changes) {
        HashMap entityProperties = modelEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)modelEntity.properties());
        String entityName = ident.name();
        String entityComment = modelEntity.comment();
        Long entityId = modelEntity.id();
        AuditInfo entityAuditInfo = modelEntity.auditInfo();
        Namespace entityNamespace = modelEntity.namespace();
        Integer entityLatestVersion = modelEntity.latestVersion();
        String modifier = PrincipalUtils.getCurrentPrincipal().getName();
        for (ModelChange change : changes) {
            if (change instanceof ModelChange.RenameModel) {
                entityName = ((ModelChange.RenameModel)change).newName();
                continue;
            }
            if (change instanceof ModelChange.SetProperty) {
                ModelChange.SetProperty setPropertyChange = (ModelChange.SetProperty)change;
                this.doSetProperty((Map<String, String>)entityProperties, setPropertyChange);
                continue;
            }
            if (change instanceof ModelChange.RemoveProperty) {
                ModelChange.RemoveProperty removePropertyChange = (ModelChange.RemoveProperty)change;
                this.doRemoveProperty((Map<String, String>)entityProperties, removePropertyChange);
                continue;
            }
            if (change instanceof ModelChange.UpdateComment) {
                entityComment = ((ModelChange.UpdateComment)change).newComment();
                continue;
            }
            throw new IllegalArgumentException("Unsupported model change: " + change.getClass().getSimpleName());
        }
        return ModelEntity.builder().withName(entityName).withId(entityId).withComment(entityComment).withAuditInfo(AuditInfo.builder().withCreator(entityAuditInfo.creator()).withCreateTime(entityAuditInfo.createTime()).withLastModifier(modifier).withLastModifiedTime(Instant.now()).build()).withNamespace(entityNamespace).withProperties((Map)entityProperties).withLatestVersion(entityLatestVersion).build();
    }

    private ModelVersion internalUpdateModelVersion(NameIdentifier ident, ModelVersionChange ... changes) {
        NameIdentifier modelIdent = NameIdentifierUtil.toModelIdentifier((NameIdentifier)ident);
        try {
            if (!this.store.exists(modelIdent, Entity.EntityType.MODEL)) {
                throw new NoSuchModelException("Model %s does not exist", new Object[]{modelIdent});
            }
            if (!this.store.exists(ident, Entity.EntityType.MODEL_VERSION)) {
                throw new NoSuchModelVersionException("Model version %s does not exist", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to alter model version " + String.valueOf(ident), ioe);
        }
        try {
            ModelVersionEntity updatedModelVersionEntity = (ModelVersionEntity)this.store.update(ident, ModelVersionEntity.class, Entity.EntityType.MODEL_VERSION, e -> this.updateModelVersionEntity((ModelVersionEntity)e, changes));
            return this.toModelVersionImpl(updatedModelVersionEntity);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load model version " + String.valueOf(ident), ioe);
        }
        catch (NoSuchEntityException nsee) {
            throw new NoSuchModelVersionException((Throwable)nsee, "Model Version %s does not exist", new Object[]{ident});
        }
    }

    private ModelVersionEntity updateModelVersionEntity(ModelVersionEntity modelVersionEntity, ModelVersionChange ... changes) {
        NameIdentifier entityModelIdentifier = modelVersionEntity.modelIdentifier();
        int entityVersion = modelVersionEntity.version();
        String entityComment = modelVersionEntity.comment();
        ArrayList entityAliases = modelVersionEntity.aliases() == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)modelVersionEntity.aliases());
        HashMap entityUris = Maps.newHashMap((Map)modelVersionEntity.uris());
        HashMap entityProperties = modelVersionEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)modelVersionEntity.properties());
        AuditInfo entityAuditInfo = modelVersionEntity.auditInfo();
        String modifier = PrincipalUtils.getCurrentPrincipal().getName();
        for (ModelVersionChange change : changes) {
            if (change instanceof ModelVersionChange.UpdateComment) {
                entityComment = ((ModelVersionChange.UpdateComment)change).newComment();
                continue;
            }
            if (change instanceof ModelVersionChange.SetProperty) {
                ModelVersionChange.SetProperty setPropertyChange = (ModelVersionChange.SetProperty)change;
                this.doSetProperty((Map<String, String>)entityProperties, setPropertyChange);
                continue;
            }
            if (change instanceof ModelVersionChange.RemoveProperty) {
                ModelVersionChange.RemoveProperty removePropertyChange = (ModelVersionChange.RemoveProperty)change;
                this.doRemoveProperty((Map<String, String>)entityProperties, removePropertyChange);
                continue;
            }
            if (change instanceof ModelVersionChange.UpdateUri) {
                ModelVersionChange.UpdateUri updateUriChange = (ModelVersionChange.UpdateUri)change;
                this.doUpdateUri(entityUris, updateUriChange);
                continue;
            }
            if (change instanceof ModelVersionChange.AddUri) {
                ModelVersionChange.AddUri addUriChange = (ModelVersionChange.AddUri)change;
                this.doAddUri(entityUris, addUriChange);
                continue;
            }
            if (change instanceof ModelVersionChange.RemoveUri) {
                ModelVersionChange.RemoveUri removeUriChange = (ModelVersionChange.RemoveUri)change;
                this.doRemoveUri(entityUris, removeUriChange);
                continue;
            }
            if (change instanceof ModelVersionChange.UpdateAliases) {
                ModelVersionChange.UpdateAliases updateAliasesChange = (ModelVersionChange.UpdateAliases)change;
                Set addTmpSet = updateAliasesChange.aliasesToAdd();
                Set deleteTmpSet = updateAliasesChange.aliasesToRemove();
                ImmutableSet aliasToAdd = Sets.difference((Set)addTmpSet, (Set)deleteTmpSet).immutableCopy();
                ImmutableSet aliasToDelete = Sets.difference((Set)deleteTmpSet, (Set)addTmpSet).immutableCopy();
                this.doDeleteAlias(entityAliases, (Set<String>)aliasToDelete);
                this.doSetAlias(entityAliases, (Set<String>)aliasToAdd);
                continue;
            }
            throw new IllegalArgumentException("Unsupported model version change: " + change.getClass().getSimpleName());
        }
        if (entityUris.isEmpty()) {
            throw new IllegalArgumentException("Model version URI cannot be empty");
        }
        return ModelVersionEntity.builder().withVersion(entityVersion).withModelIdentifier(entityModelIdentifier).withAliases((List)entityAliases).withComment(entityComment).withUris((Map)entityUris).withProperties((Map)entityProperties).withAuditInfo(AuditInfo.builder().withCreator(entityAuditInfo.creator()).withCreateTime(entityAuditInfo.createTime()).withLastModifier(modifier).withLastModifiedTime(Instant.now()).build()).build();
    }

    private ModelImpl toModelImpl(ModelEntity model) {
        return (ModelImpl)((ModelImpl.Builder)((ModelImpl.Builder)((ModelImpl.Builder)((ModelImpl.Builder)((ModelImpl.Builder)ModelImpl.builder().withName(model.name())).withComment(model.comment())).withProperties(model.properties())).withLatestVersion(model.latestVersion())).withAuditInfo(model.auditInfo())).build();
    }

    private ModelVersionImpl toModelVersionImpl(ModelVersionEntity modelVersion) {
        return (ModelVersionImpl)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)ModelVersionImpl.builder().withVersion(modelVersion.version())).withAliases(modelVersion.aliases().toArray(new String[0]))).withUris(modelVersion.uris())).withComment(modelVersion.comment())).withProperties(modelVersion.properties())).withAuditInfo(modelVersion.auditInfo())).build();
    }

    private ModelVersion internalGetModelVersion(NameIdentifier ident) {
        try {
            ModelVersionEntity modelVersion = (ModelVersionEntity)this.store.get(ident, Entity.EntityType.MODEL_VERSION, ModelVersionEntity.class);
            return this.toModelVersionImpl(modelVersion);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelVersionException((Throwable)e, "Model version %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get model version " + String.valueOf(ident), ioe);
        }
    }

    private String internalGetModelVersionUri(NameIdentifier modelIdent, NameIdentifier modelVersionIdent, Optional<String> uriName) {
        ModelVersion modelVersion = this.internalGetModelVersion(modelVersionIdent);
        Map uris = modelVersion.uris();
        if (uriName.isPresent()) {
            return this.getUriByName(uris, uriName.get(), modelVersionIdent);
        }
        if (uris.size() == 1) {
            return (String)uris.values().iterator().next();
        }
        Map modelVersionProperties = modelVersion.properties();
        if (modelVersionProperties.containsKey("default-uri-name")) {
            String defaultUriName = (String)modelVersionProperties.get("default-uri-name");
            return this.getUriByName(uris, defaultUriName, modelVersionIdent);
        }
        Map modelProperties = this.getModel(modelIdent).properties();
        if (modelProperties.containsKey("default-uri-name")) {
            String defaultUriName = (String)modelProperties.get("default-uri-name");
            return this.getUriByName(uris, defaultUriName, modelVersionIdent);
        }
        throw new IllegalArgumentException("The default uri name needs to be set when the uri name is not specified");
    }

    private String getUriByName(Map<String, String> uris, String uriName, NameIdentifier modelVersionIdent) {
        if (!uris.containsKey(uriName)) {
            throw new NoSuchModelVersionURINameException("URI name %s does not exist in model version %s", new Object[]{uriName, modelVersionIdent});
        }
        return uris.get(uriName);
    }

    private boolean internalDeleteModelVersion(NameIdentifier ident) {
        try {
            return this.store.delete(ident, Entity.EntityType.MODEL_VERSION);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete model version " + String.valueOf(ident), ioe);
        }
    }

    private void doRemoveProperty(Map<String, String> entityProperties, ModelChange.RemoveProperty change) {
        entityProperties.remove(change.property());
    }

    private void doSetProperty(Map<String, String> entityProperties, ModelChange.SetProperty change) {
        entityProperties.put(change.property(), change.value());
    }

    private void doSetProperty(Map<String, String> entityProperties, ModelVersionChange.SetProperty change) {
        entityProperties.put(change.property(), change.value());
    }

    private void doRemoveProperty(Map<String, String> entityProperties, ModelVersionChange.RemoveProperty change) {
        entityProperties.remove(change.property());
    }

    private void doUpdateUri(Map<String, String> entityUris, ModelVersionChange.UpdateUri change) {
        entityUris.replace(change.uriName(), change.newUri());
    }

    private void doAddUri(Map<String, String> entityUris, ModelVersionChange.AddUri change) {
        entityUris.putIfAbsent(change.uriName(), change.uri());
    }

    private void doRemoveUri(Map<String, String> entityUris, ModelVersionChange.RemoveUri change) {
        entityUris.remove(change.uriName());
    }

    private void doDeleteAlias(List<String> entityAliases, Set<String> deleteSet) {
        entityAliases.removeAll(deleteSet);
    }

    private void doSetAlias(List<String> entityAliases, Set<String> addSet) {
        HashSet<String> aliasSet = new HashSet<String>(entityAliases);
        for (String alias : addSet) {
            if (!aliasSet.add(alias)) continue;
            entityAliases.add(alias);
        }
    }
}

