/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.dto.requests.TagsAssociateRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.TagListResponse;
import org.apache.gravitino.dto.responses.TagResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationFullName;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.AuthorizationObjectType;
import org.apache.gravitino.server.authorization.annotations.AuthorizationRequest;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagDispatcher;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/objects/{type}/{fullName}/tags")
public class MetadataObjectTagOperations {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataObjectTagOperations.class);
    private final TagDispatcher tagDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public MetadataObjectTagOperations(TagDispatcher tagDispatcher) {
        this.tagDispatcher = tagDispatcher;
    }

    void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @GET
    @Path(value="{tag}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-object-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-object-tag", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || ((TAG::OWNER || ANY_APPLY_TAG) && CAN_ACCESS_METADATA)")
    public Response getTagForObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @PathParam(value="tag") @AuthorizationMetadata(type=Entity.EntityType.TAG) String tagName) {
        LOG.info("Received get tag {} request for object type: {}, full name: {} under metalake: {}", new Object[]{tagName, type, fullName, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                Optional<Tag> tag = this.getTagForObject(metalake, object, tagName);
                Optional<TagDTO> tagDTO = tag.map(t -> DTOConverters.toDTO((Tag)t, Optional.of(false)));
                MetadataObject parentObject = MetadataObjects.parent((MetadataObject)object);
                while (!tag.isPresent() && parentObject != null) {
                    tag = this.getTagForObject(metalake, parentObject, tagName);
                    tagDTO = tag.map(t -> DTOConverters.toDTO((Tag)t, Optional.of(true)));
                    parentObject = MetadataObjects.parent((MetadataObject)parentObject);
                }
                if (!tagDTO.isPresent()) {
                    LOG.warn("Tag {} not found for object type: {}, full name: {} under metalake: {}", new Object[]{tagName, type, fullName, metalake});
                    return Utils.notFound((String)NoSuchTagException.class.getSimpleName(), (String)("Tag not found: " + tagName + " for object type: " + type + ", full name: " + fullName + " under metalake: " + metalake));
                }
                LOG.info("Get tag: {} for object type: {}, full name: {} under metalake: {}", new Object[]{tagName, type, fullName, metalake});
                return Utils.ok((Object)new TagResponse(tagDTO.get()));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.GET, tagName, fullName, e);
        }
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-object-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-object-tags", absolute=true)
    @AuthorizationExpression(expression="CAN_ACCESS_METADATA")
    public Response listTagsForMetadataObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list tag {} request for object type: {}, full name: {} under metalake: {}", new Object[]{verbose ? "infos" : "names", type, fullName, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                HashSet tags = Sets.newHashSet();
                Object[] nonInheritedTags = this.tagDispatcher.listTagsInfoForMetadataObject(metalake, object);
                if (ArrayUtils.isNotEmpty((Object[])nonInheritedTags)) {
                    Collections.addAll(tags, (TagDTO[])Arrays.stream(nonInheritedTags).map(t -> DTOConverters.toDTO((Tag)t, Optional.of(false))).toArray(TagDTO[]::new));
                }
                MetadataObject parentObject = MetadataObjects.parent((MetadataObject)object);
                while (parentObject != null) {
                    Object[] inheritedTags = this.tagDispatcher.listTagsInfoForMetadataObject(metalake, parentObject);
                    if (ArrayUtils.isNotEmpty((Object[])inheritedTags)) {
                        Collections.addAll(tags, (TagDTO[])Arrays.stream(inheritedTags).map(t -> DTOConverters.toDTO((Tag)t, Optional.of(true))).toArray(TagDTO[]::new));
                    }
                    parentObject = MetadataObjects.parent((MetadataObject)parentObject);
                }
                if (verbose) {
                    LOG.info("List {} tags info for object type: {}, full name: {} under metalake: {}", new Object[]{tags.size(), type, fullName, metalake});
                    Object[] tagDTOS = tags.toArray(new TagDTO[0]);
                    tagDTOS = (TagDTO[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || TAG::OWNER || ANY_APPLY_TAG", (Entity.EntityType)Entity.EntityType.TAG, (Object[])tagDTOS, tagDTO -> NameIdentifierUtil.ofTag((String)metalake, (String)tagDTO.name()));
                    return Utils.ok((Object)new TagListResponse((TagDTO[])tagDTOS));
                }
                Object[] tagNames = (String[])tags.stream().map(TagDTO::name).toArray(String[]::new);
                tagNames = (String[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || TAG::OWNER || ANY_APPLY_TAG", (Entity.EntityType)Entity.EntityType.TAG, (Object[])tagNames, tagName -> NameIdentifierUtil.ofTag((String)metalake, (String)tagName));
                LOG.info("List {} tags for object type: {}, full name: {} under metalake: {}", new Object[]{tagNames.length, type, fullName, metalake});
                return Utils.ok((Object)new NameListResponse((String[])tagNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.LIST, "", fullName, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="associate-object-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="associate-object-tags", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER ||\n((CAN_ACCESS_METADATA) && (TAG::OWNER || ANY_APPLY_TAG))\n")
    public Response associateTagsForObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @AuthorizationRequest(type=AuthorizationRequest.RequestType.ASSOCIATE_TAG) TagsAssociateRequest request) {
        LOG.info("Received associate tags request for object type: {}, full name: {} under metalake: {}", new Object[]{type, fullName, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                Object[] tagNames = this.tagDispatcher.associateTagsForMetadataObject(metalake, object, request.getTagsToAdd(), request.getTagsToRemove());
                tagNames = tagNames == null ? new String[]{} : tagNames;
                LOG.info("Associated tags: {} for object type: {}, full name: {} under metalake: {}", new Object[]{Arrays.toString(tagNames), type, fullName, metalake});
                return Utils.ok((Object)new NameListResponse((String[])tagNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.ASSOCIATE, "", fullName, e);
        }
    }

    private Optional<Tag> getTagForObject(String metalake, MetadataObject object, String tagName) {
        try {
            return Optional.ofNullable(this.tagDispatcher.getTagForMetadataObject(metalake, object, tagName));
        }
        catch (NoSuchTagException e) {
            LOG.info("Tag {} not found for object: {}", (Object)tagName, (Object)object);
            return Optional.empty();
        }
    }
}

