/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.EvalMode;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.utils.Utils;
import java.math.MathContext;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public enum Options {
    OPTIMIZE_LEVEL,
    MATH_CONTEXT,
    ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL,
    ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL,
    TRACE_EVAL,
    PUT_CAPTURING_GROUPS_INTO_ENV,
    CAPTURE_FUNCTION_ARGS,
    ENABLE_PROPERTY_SYNTAX_SUGAR,
    NIL_WHEN_PROPERTY_NOT_FOUND,
    USE_USER_ENV_AS_TOP_ENV_DIRECTLY,
    MAX_LOOP_COUNT,
    FEATURE_SET,
    ALLOWED_CLASS_SET,
    ASSIGNABLE_ALLOWED_CLASS_SET,
    EVAL_MODE,
    SERIALIZABLE,
    EVAL_TIMEOUT_MS;

    public static final Value FALSE_VALUE;
    public static final Value TRUE_VALUE;
    public static final Value ZERO_VALUE;
    public static final Value DEFAULT_MATH_CONTEXT;
    public static final Value EVAL_VALUE;
    public static final Value COMPILE_VALUE;
    private static final Value FULL_FEATURE_SET;
    private static final boolean TRACE_EVAL_DEFAULT_VAL;
    public static final Value ASM_MODE;
    public static final Value INTERPRETER_MODE;
    public static final Value NULL_CLASS_SET;
    public static Value SYS_EVAL_MODE;

    public Object intoObject(Value val) {
        if (val == null) {
            return null;
        }
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case CAPTURE_FUNCTION_ARGS: {
                return val.bool;
            }
            case MAX_LOOP_COUNT: 
            case OPTIMIZE_LEVEL: 
            case EVAL_TIMEOUT_MS: {
                return val.number;
            }
            case FEATURE_SET: {
                return val.featureSet;
            }
            case MATH_CONTEXT: {
                return val.mathContext;
            }
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return val.classes;
            }
            case EVAL_MODE: {
                return val.evalMode;
            }
            case SERIALIZABLE: {
                return val.bool;
            }
        }
        throw new IllegalArgumentException("Fail to cast value " + val + " for option " + (Object)((Object)this));
    }

    public Value intoValue(Object val) {
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case CAPTURE_FUNCTION_ARGS: 
            case SERIALIZABLE: {
                return (Boolean)val != false ? TRUE_VALUE : FALSE_VALUE;
            }
            case OPTIMIZE_LEVEL: {
                int level = (Integer)val;
                if (level == 1) {
                    return EVAL_VALUE;
                }
                return COMPILE_VALUE;
            }
            case EVAL_TIMEOUT_MS: {
                Value value = new Value(((Number)val).intValue());
                if (value.number > 0) {
                    value.cachedNumber = TimeUnit.NANOSECONDS.convert(value.number, TimeUnit.MILLISECONDS);
                }
                return value;
            }
            case MAX_LOOP_COUNT: {
                return new Value(((Number)val).intValue());
            }
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return Value.fromClasses((Set)val);
            }
            case FEATURE_SET: {
                return new Value((Set)val);
            }
            case MATH_CONTEXT: {
                return new Value((MathContext)val);
            }
            case EVAL_MODE: {
                return new Value((EvalMode)((Object)val));
            }
        }
        throw new IllegalArgumentException("Fail to cast value " + val + " for option " + (Object)((Object)this));
    }

    public boolean isValidValue(Object val) {
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case CAPTURE_FUNCTION_ARGS: 
            case SERIALIZABLE: {
                return val instanceof Boolean;
            }
            case FEATURE_SET: 
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return val instanceof Set;
            }
            case OPTIMIZE_LEVEL: {
                int level = (Integer)val;
                return val instanceof Integer && (level == 1 || level == 0);
            }
            case MAX_LOOP_COUNT: 
            case EVAL_TIMEOUT_MS: {
                return val instanceof Long || val instanceof Integer;
            }
            case MATH_CONTEXT: {
                return val instanceof MathContext;
            }
            case EVAL_MODE: {
                return val instanceof EvalMode;
            }
        }
        return false;
    }

    public Object getDefaultValue() {
        return this.intoObject(this.getDefaultValueObject());
    }

    public Value getDefaultValueObject() {
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case SERIALIZABLE: {
                return FALSE_VALUE;
            }
            case ENABLE_PROPERTY_SYNTAX_SUGAR: {
                return TRUE_VALUE;
            }
            case NIL_WHEN_PROPERTY_NOT_FOUND: {
                return FALSE_VALUE;
            }
            case OPTIMIZE_LEVEL: {
                return EVAL_VALUE;
            }
            case MATH_CONTEXT: {
                return DEFAULT_MATH_CONTEXT;
            }
            case TRACE_EVAL: {
                return TRACE_EVAL_DEFAULT_VAL ? TRUE_VALUE : FALSE_VALUE;
            }
            case PUT_CAPTURING_GROUPS_INTO_ENV: {
                return TRUE_VALUE;
            }
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: {
                return TRUE_VALUE;
            }
            case CAPTURE_FUNCTION_ARGS: {
                return FALSE_VALUE;
            }
            case MAX_LOOP_COUNT: {
                return ZERO_VALUE;
            }
            case FEATURE_SET: {
                return FULL_FEATURE_SET;
            }
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return NULL_CLASS_SET;
            }
            case EVAL_MODE: {
                return Options.getDefaultEvalMode();
            }
            case EVAL_TIMEOUT_MS: {
                return ZERO_VALUE;
            }
        }
        return null;
    }

    public static Value getDefaultEvalMode() {
        if (SYS_EVAL_MODE != null) {
            return SYS_EVAL_MODE;
        }
        return Utils.isAndroid() ? INTERPRETER_MODE : ASM_MODE;
    }

    private static Value getSystemEvalMode() {
        String sysProperty = System.getProperty("aviator.eval.mode");
        Value result = null;
        if (sysProperty != null && sysProperty.trim().length() > 0) {
            try {
                EvalMode mode = EvalMode.valueOf(sysProperty.trim().toUpperCase());
                switch (mode) {
                    case ASM: {
                        result = ASM_MODE;
                        break;
                    }
                    case INTERPRETER: {
                        result = INTERPRETER_MODE;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (result != null) {
            System.out.println("[Aviator INFO] Using " + result.evalMode.name() + " eval mode by system property setting aviator.eval.mode");
        }
        return result;
    }

    static {
        FALSE_VALUE = new Value(false);
        TRUE_VALUE = new Value(true);
        ZERO_VALUE = new Value(0);
        DEFAULT_MATH_CONTEXT = new Value(MathContext.DECIMAL128);
        EVAL_VALUE = new Value(1);
        COMPILE_VALUE = new Value(0);
        FULL_FEATURE_SET = new Value(Feature.getFullFeatures());
        TRACE_EVAL_DEFAULT_VAL = Boolean.parseBoolean(System.getProperty("aviator.trace_eval", "false"));
        ASM_MODE = new Value(EvalMode.ASM);
        INTERPRETER_MODE = new Value(EvalMode.INTERPRETER);
        NULL_CLASS_SET = Value.fromClasses(null);
        SYS_EVAL_MODE = Options.getSystemEvalMode();
    }

    public static class Value {
        public boolean bool;
        public MathContext mathContext;
        public int number;
        public Set<Feature> featureSet;
        public Set<Class<?>> classes;
        public EvalMode evalMode;
        public long cachedNumber;

        public Value(EvalMode evalMode) {
            this.evalMode = evalMode;
        }

        public Value() {
        }

        static Value fromClasses(Set<Class<?>> classes) {
            Value v = new Value();
            v.classes = classes;
            return v;
        }

        public Value(Set<Feature> featureSet) {
            this.featureSet = featureSet;
        }

        public Value(boolean bool) {
            this.bool = bool;
        }

        public Value(MathContext mathContext) {
            this.mathContext = mathContext;
        }

        public Value(int n) {
            this.number = n;
        }

        public String toString() {
            return "Value [bool=" + this.bool + ", mathContext=" + this.mathContext + ", number=" + this.number + ", featureSet=" + this.featureSet + ", classes=" + this.classes + "]";
        }
    }
}

