/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc;

import java.util.Collections;
import java.util.Map;
import org.apache.gravitino.catalog.jdbc.JdbcCatalogCapability;
import org.apache.gravitino.catalog.jdbc.JdbcCatalogOperations;
import org.apache.gravitino.catalog.jdbc.JdbcCatalogPropertiesMetadata;
import org.apache.gravitino.catalog.jdbc.JdbcSchemaPropertiesMetadata;
import org.apache.gravitino.catalog.jdbc.JdbcTablePropertiesMetadata;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;
import org.apache.gravitino.connector.capability.Capability;

public abstract class JdbcCatalog
extends BaseCatalog<JdbcCatalog> {
    private static final JdbcCatalogPropertiesMetadata CATALOG_PROPERTIES_META = new JdbcCatalogPropertiesMetadata();
    private static final JdbcSchemaPropertiesMetadata SCHEMA_PROPERTIES_META = new JdbcSchemaPropertiesMetadata();
    private static final JdbcTablePropertiesMetadata TABLE_PROPERTIES_META = new JdbcTablePropertiesMetadata(){

        protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
            return Collections.emptyMap();
        }
    };

    protected CatalogOperations newOps(Map<String, String> config) {
        JdbcTypeConverter jdbcTypeConverter = this.createJdbcTypeConverter();
        JdbcCatalogOperations ops = new JdbcCatalogOperations(this.createExceptionConverter(), jdbcTypeConverter, this.createJdbcDatabaseOperations(), this.createJdbcTableOperations(), this.createJdbcColumnDefaultValueConverter());
        return ops;
    }

    public Capability newCapability() {
        return new JdbcCatalogCapability();
    }

    protected JdbcExceptionConverter createExceptionConverter() {
        return new JdbcExceptionConverter(){};
    }

    protected abstract JdbcTypeConverter createJdbcTypeConverter();

    protected abstract JdbcDatabaseOperations createJdbcDatabaseOperations();

    protected abstract JdbcTableOperations createJdbcTableOperations();

    protected abstract JdbcColumnDefaultValueConverter createJdbcColumnDefaultValueConverter();

    public PropertiesMetadata catalogPropertiesMetadata() throws UnsupportedOperationException {
        return CATALOG_PROPERTIES_META;
    }

    public PropertiesMetadata schemaPropertiesMetadata() throws UnsupportedOperationException {
        return SCHEMA_PROPERTIES_META;
    }

    public PropertiesMetadata tablePropertiesMetadata() throws UnsupportedOperationException {
        return TABLE_PROPERTIES_META;
    }
}

