/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.utils.Preconditions;

public class Levels {
    private final Comparator<InternalRow> keyComparator;
    private final TreeSet<DataFileMeta> level0;
    private final List<SortedRun> levels;
    private final List<DropFileCallback> dropFileCallbacks = new ArrayList<DropFileCallback>();

    public Levels(Comparator<InternalRow> keyComparator, List<DataFileMeta> inputFiles, int numLevels) {
        this.keyComparator = keyComparator;
        int restoredNumLevels = Math.max(numLevels, inputFiles.stream().mapToInt(DataFileMeta::level).max().orElse(-1) + 1);
        Preconditions.checkArgument((restoredNumLevels > 1 ? 1 : 0) != 0, (Object)"Number of levels must be at least 2.");
        this.level0 = new TreeSet((a, b) -> {
            if (a.maxSequenceNumber() != b.maxSequenceNumber()) {
                return Long.compare(b.maxSequenceNumber(), a.maxSequenceNumber());
            }
            return a.fileName().compareTo(b.fileName());
        });
        this.levels = new ArrayList<SortedRun>();
        for (int i = 1; i < restoredNumLevels; ++i) {
            this.levels.add(SortedRun.empty());
        }
        HashMap<Integer, List> levelMap = new HashMap<Integer, List>();
        for (DataFileMeta file : inputFiles) {
            levelMap.computeIfAbsent(file.level(), level -> new ArrayList()).add(file);
        }
        levelMap.forEach((level, files) -> this.updateLevel((int)level, Collections.emptyList(), (List<DataFileMeta>)files));
        Preconditions.checkState((this.level0.size() + this.levels.stream().mapToInt(r -> r.files().size()).sum() == inputFiles.size() ? 1 : 0) != 0, (Object)"Number of files stored in Levels does not equal to the size of inputFiles. This is unexpected.");
    }

    public TreeSet<DataFileMeta> level0() {
        return this.level0;
    }

    public void addDropFileCallback(DropFileCallback callback) {
        this.dropFileCallbacks.add(callback);
    }

    public void addLevel0File(DataFileMeta file) {
        Preconditions.checkArgument((file.level() == 0 ? 1 : 0) != 0);
        this.level0.add(file);
    }

    public SortedRun runOfLevel(int level) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Level0 does not have one single sorted run.");
        return this.levels.get(level - 1);
    }

    public int numberOfLevels() {
        return this.levels.size() + 1;
    }

    public int maxLevel() {
        return this.levels.size();
    }

    public int numberOfSortedRuns() {
        int numberOfSortedRuns = this.level0.size();
        for (SortedRun run : this.levels) {
            if (!run.nonEmpty()) continue;
            ++numberOfSortedRuns;
        }
        return numberOfSortedRuns;
    }

    public int nonEmptyHighestLevel() {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).nonEmpty()) continue;
            return i + 1;
        }
        return this.level0.isEmpty() ? -1 : 0;
    }

    public long totalFileSize() {
        return this.level0.stream().mapToLong(DataFileMeta::fileSize).sum() + this.levels.stream().mapToLong(SortedRun::totalSize).sum();
    }

    public List<DataFileMeta> allFiles() {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        List<LevelSortedRun> runs = this.levelSortedRuns();
        for (LevelSortedRun run : runs) {
            files.addAll(run.run().files());
        }
        return files;
    }

    public List<LevelSortedRun> levelSortedRuns() {
        ArrayList<LevelSortedRun> runs = new ArrayList<LevelSortedRun>();
        this.level0.forEach(file -> runs.add(new LevelSortedRun(0, SortedRun.fromSingle(file))));
        for (int i = 0; i < this.levels.size(); ++i) {
            SortedRun run = this.levels.get(i);
            if (!run.nonEmpty()) continue;
            runs.add(new LevelSortedRun(i + 1, run));
        }
        return runs;
    }

    public void update(List<DataFileMeta> before, List<DataFileMeta> after) {
        Map<Integer, List<DataFileMeta>> groupedBefore = this.groupByLevel(before);
        Map<Integer, List<DataFileMeta>> groupedAfter = this.groupByLevel(after);
        for (int i = 0; i < this.numberOfLevels(); ++i) {
            this.updateLevel(i, groupedBefore.getOrDefault(i, Collections.emptyList()), groupedAfter.getOrDefault(i, Collections.emptyList()));
        }
        if (this.dropFileCallbacks.size() > 0) {
            Set<String> droppedFiles = before.stream().map(DataFileMeta::fileName).collect(Collectors.toSet());
            after.stream().map(DataFileMeta::fileName).forEach(droppedFiles::remove);
            for (DropFileCallback callback : this.dropFileCallbacks) {
                droppedFiles.forEach(callback::notifyDropFile);
            }
        }
    }

    private void updateLevel(int level, List<DataFileMeta> before, List<DataFileMeta> after) {
        if (before.isEmpty() && after.isEmpty()) {
            return;
        }
        if (level == 0) {
            before.forEach(this.level0::remove);
            this.level0.addAll(after);
        } else {
            ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(this.runOfLevel(level).files());
            files.removeAll(before);
            files.addAll(after);
            this.levels.set(level - 1, SortedRun.fromUnsorted(files, this.keyComparator));
        }
    }

    private Map<Integer, List<DataFileMeta>> groupByLevel(List<DataFileMeta> files) {
        return files.stream().collect(Collectors.groupingBy(DataFileMeta::level, Collectors.toList()));
    }

    public static interface DropFileCallback {
        public void notifyDropFile(String var1);
    }
}

