/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerializationUtils;

@Public
public class SimpleStats {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_MIN_VALUES", (DataType)SerializationUtils.newBytesType(false)), new DataField(1, "_MAX_VALUES", (DataType)SerializationUtils.newBytesType(false)), new DataField(2, "_NULL_COUNTS", (DataType)new ArrayType((DataType)new BigIntType(true)))));
    public static final SimpleStats EMPTY_STATS = new SimpleStats(BinaryRow.EMPTY_ROW, BinaryRow.EMPTY_ROW, BinaryArray.fromLongArray((Long[])new Long[0]));
    private final BinaryRow minValues;
    private final BinaryRow maxValues;
    private final BinaryArray nullCounts;

    public SimpleStats(BinaryRow minValues, BinaryRow maxValues, BinaryArray nullCounts) {
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.nullCounts = nullCounts;
    }

    public BinaryRow minValues() {
        return this.minValues;
    }

    public BinaryRow maxValues() {
        return this.maxValues;
    }

    public BinaryArray nullCounts() {
        return this.nullCounts;
    }

    public InternalRow toRow() {
        return GenericRow.of((Object[])new Object[]{SerializationUtils.serializeBinaryRow(this.minValues), SerializationUtils.serializeBinaryRow(this.maxValues), this.nullCounts});
    }

    public static SimpleStats fromRow(InternalRow row) {
        BinaryRow minValues = SerializationUtils.deserializeBinaryRow(row.getBinary(0));
        BinaryRow maxValues = SerializationUtils.deserializeBinaryRow(row.getBinary(1));
        InternalArray nullCounts = row.getArray(2);
        if (minValues.getFieldCount() == 0 && maxValues.getFieldCount() == 0 && nullCounts.size() == 0) {
            return EMPTY_STATS;
        }
        return new SimpleStats(minValues, maxValues, BinaryArray.fromLongArray((InternalArray)nullCounts));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleStats that = (SimpleStats)o;
        return Objects.equals(this.minValues, that.minValues) && Objects.equals(this.maxValues, that.maxValues) && Objects.equals(this.nullCounts, that.nullCounts);
    }

    public int hashCode() {
        return Objects.hash(this.minValues, this.maxValues, this.nullCounts);
    }
}

