/*
 * Decompiled with CFR 0.152.
 */
package ognl.enhance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import ognl.ASTAnd;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.ASTCtor;
import ognl.ASTList;
import ognl.ASTMethod;
import ognl.ASTOr;
import ognl.ASTProperty;
import ognl.ASTRootVarRef;
import ognl.ASTStaticField;
import ognl.ASTStaticMethod;
import ognl.ASTVarRef;
import ognl.ClassResolver;
import ognl.ExpressionNode;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlRuntime;
import ognl.enhance.ContextClassLoader;
import ognl.enhance.EnhancedClassLoader;
import ognl.enhance.ExpressionAccessor;
import ognl.enhance.LocalReference;
import ognl.enhance.OgnlExpressionCompiler;
import ognl.enhance.OgnlLocalReference;
import ognl.enhance.OrderedReturn;
import ognl.enhance.UnsupportedCompilationException;

public class ExpressionCompiler
implements OgnlExpressionCompiler {
    public static final String PRE_CAST = "_preCast";
    protected Map<ClassResolver, EnhancedClassLoader> loaders = new HashMap<ClassResolver, EnhancedClassLoader>();
    protected ClassPool classPool;
    protected int classCounter = 0;

    public static void addCastString(OgnlContext context, String cast) {
        String value = (String)context.get(PRE_CAST);
        value = value != null ? cast + value : cast;
        context.put(PRE_CAST, (Object)value);
    }

    public static String getCastString(Class<?> type) {
        if (type == null) {
            return null;
        }
        return type.isArray() ? type.getComponentType().getName() + "[]" : type.getName();
    }

    public static String getRootExpression(Node expression, Object root, OgnlContext context) {
        String rootExpr = "";
        if (!ExpressionCompiler.shouldCast(expression)) {
            return rootExpr;
        }
        if (!(expression instanceof ASTList) && !(expression instanceof ASTVarRef) && !(expression instanceof ASTStaticMethod) && !(expression instanceof ASTStaticField) && !(expression instanceof ASTConst) && !(expression instanceof ExpressionNode) && !(expression instanceof ASTCtor) && root != null || root != null && expression instanceof ASTRootVarRef) {
            Class<?> castClass = OgnlRuntime.getCompiler().getRootExpressionClass(expression, context);
            if (castClass.isArray() || expression instanceof ASTRootVarRef) {
                rootExpr = "((" + ExpressionCompiler.getCastString(castClass) + ")$2)";
                if (expression instanceof ASTProperty && !((ASTProperty)expression).isIndexedAccess()) {
                    rootExpr = rootExpr + ".";
                }
            } else {
                rootExpr = expression instanceof ASTProperty && ((ASTProperty)expression).isIndexedAccess() || expression instanceof ASTChain ? "((" + ExpressionCompiler.getCastString(castClass) + ")$2)" : "((" + ExpressionCompiler.getCastString(castClass) + ")$2).";
            }
        }
        return rootExpr;
    }

    public static boolean shouldCast(Node expression) {
        Node child;
        if (expression instanceof ASTChain && ((child = expression.jjtGetChild(0)) instanceof ASTConst || child instanceof ASTStaticMethod || child instanceof ASTStaticField || child instanceof ASTVarRef && !(child instanceof ASTRootVarRef))) {
            return false;
        }
        return !(expression instanceof ASTConst);
    }

    @Override
    public String castExpression(OgnlContext context, Node expression, String body) {
        if (context.getCurrentAccessor() == null || context.getPreviousType() == null || context.getCurrentAccessor().isAssignableFrom(context.getPreviousType()) || context.getCurrentType() != null && context.getCurrentObject() != null && context.getCurrentType().isAssignableFrom(context.getCurrentObject().getClass()) && context.getCurrentAccessor().isAssignableFrom(context.getPreviousType()) || body == null || body.trim().length() < 1 || context.getCurrentType() != null && context.getCurrentType().isArray() && (context.getPreviousType() == null || context.getPreviousType() != Object.class) || expression instanceof ASTOr || expression instanceof ASTAnd || expression instanceof ASTRootVarRef || context.getCurrentAccessor() == Class.class || context.get(PRE_CAST) != null && ((String)context.get(PRE_CAST)).startsWith("new") || expression instanceof ASTStaticField || expression instanceof ASTStaticMethod || expression instanceof OrderedReturn && ((OrderedReturn)((Object)expression)).getLastExpression() != null) {
            return body;
        }
        ExpressionCompiler.addCastString(context, "((" + ExpressionCompiler.getCastString(context.getCurrentAccessor()) + ")");
        return ")" + body;
    }

    @Override
    public String getClassName(Class<?> clazz) {
        if (clazz.getName().equals("java.util.AbstractList$Itr")) {
            return Iterator.class.getName();
        }
        if (Modifier.isPublic(clazz.getModifiers()) && clazz.isInterface()) {
            return clazz.getName();
        }
        return this.getClassName(clazz, clazz.getInterfaces());
    }

    private String getClassName(Class<?> clazz, Class<?>[] interfaces) {
        Class<?>[] superClazzInterfaces;
        for (Class<?> anInterface : interfaces) {
            if (anInterface.getName().indexOf("util.List") > 0) {
                return anInterface.getName();
            }
            if (anInterface.getName().indexOf("Iterator") <= 0) continue;
            return anInterface.getName();
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && (superClazzInterfaces = superClazz.getInterfaces()).length > 0) {
            return this.getClassName(superClazz, superClazzInterfaces);
        }
        return clazz.getName();
    }

    @Override
    public Class<?> getSuperOrInterfaceClass(Method method, Class<?> clazz) {
        Class<?> superClass;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                Class<?> intClass = this.getSuperOrInterfaceClass(method, anInterface);
                if (intClass != null) {
                    return intClass;
                }
                if (!Modifier.isPublic(anInterface.getModifiers()) || !this.containsMethod(method, anInterface)) continue;
                return anInterface;
            }
        }
        if (clazz.getSuperclass() != null && (superClass = this.getSuperOrInterfaceClass(method, clazz.getSuperclass())) != null) {
            return superClass;
        }
        if (Modifier.isPublic(clazz.getModifiers()) && this.containsMethod(method, clazz)) {
            return clazz;
        }
        return null;
    }

    public boolean containsMethod(Method method, Class<?> clazz) {
        Method[] methods;
        for (Method value : methods = clazz.getMethods()) {
            if (!value.getName().equals(method.getName()) || value.getReturnType() != method.getReturnType()) continue;
            Class<?>[] parms = method.getParameterTypes();
            Class<?>[] methodParams = value.getParameterTypes();
            if (methodParams.length != parms.length) continue;
            boolean parmsMatch = true;
            for (int p = 0; p < parms.length; ++p) {
                if (parms[p] == methodParams[p]) continue;
                parmsMatch = false;
                break;
            }
            if (!parmsMatch) continue;
            Class<?>[] exceptions = method.getExceptionTypes();
            Class<?>[] methodExceptions = value.getExceptionTypes();
            if (methodExceptions.length != exceptions.length) continue;
            boolean exceptionsMatch = true;
            for (int e = 0; e < exceptions.length; ++e) {
                if (exceptions[e] == methodExceptions[e]) continue;
                exceptionsMatch = false;
                break;
            }
            if (!exceptionsMatch) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getInterfaceClass(Class<?> clazz) {
        if (clazz.getName().equals("java.util.AbstractList$Itr")) {
            return Iterator.class;
        }
        if (Modifier.isPublic(clazz.getModifiers()) && clazz.isInterface() || clazz.isPrimitive()) {
            return clazz;
        }
        return this.getInterfaceClass(clazz, clazz.getInterfaces());
    }

    private Class<?> getInterfaceClass(Class<?> clazz, Class<?>[] interfaces) {
        Class<?>[] superClazzInterfaces;
        for (Class<?> anInterface : interfaces) {
            if (List.class.isAssignableFrom(anInterface)) {
                return List.class;
            }
            if (Iterator.class.isAssignableFrom(anInterface)) {
                return Iterator.class;
            }
            if (Map.class.isAssignableFrom(anInterface)) {
                return Map.class;
            }
            if (Set.class.isAssignableFrom(anInterface)) {
                return Set.class;
            }
            if (!Collection.class.isAssignableFrom(anInterface)) continue;
            return Collection.class;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && (superClazzInterfaces = superClazz.getInterfaces()).length > 0) {
            return this.getInterfaceClass(superClazz, superClazzInterfaces);
        }
        return clazz;
    }

    @Override
    public Class<?> getRootExpressionClass(Node rootNode, OgnlContext context) {
        if (context.getRoot() == null) {
            return null;
        }
        Class<?> ret = context.getRoot().getClass();
        if (context.getFirstAccessor() != null && context.getFirstAccessor().isInstance(context.getRoot())) {
            ret = context.getFirstAccessor();
        }
        return ret;
    }

    @Override
    public void compileExpression(OgnlContext context, Node expression, Object root) throws Exception {
        String setBody;
        String getBody;
        CtField nodeMember;
        CtClass newClass;
        ClassPool pool;
        block9: {
            if (expression.getAccessor() != null) {
                return;
            }
            EnhancedClassLoader loader = this.getClassLoader(context);
            pool = this.getClassPool(context, loader);
            newClass = pool.makeClass(expression.getClass().getName() + expression.hashCode() + this.classCounter++ + "Accessor");
            newClass.addInterface(this.getCtClass(ExpressionAccessor.class));
            CtClass ognlClass = this.getCtClass(OgnlContext.class);
            CtClass objClass = this.getCtClass(Object.class);
            CtMethod valueGetter = new CtMethod(objClass, "get", new CtClass[]{ognlClass, objClass}, newClass);
            CtMethod valueSetter = new CtMethod(CtClass.voidType, "set", new CtClass[]{ognlClass, objClass, objClass}, newClass);
            nodeMember = null;
            CtClass nodeClass = this.getCtClass(Node.class);
            CtMethod setExpression = null;
            try {
                getBody = this.generateGetter(context, newClass, pool, valueGetter, expression, root);
            }
            catch (UnsupportedCompilationException uc) {
                nodeMember = new CtField(nodeClass, "_node", newClass);
                newClass.addField(nodeMember);
                getBody = this.generateOgnlGetter(newClass, valueGetter, nodeMember);
                setExpression = CtNewMethod.setter((String)"setExpression", (CtField)nodeMember);
                newClass.addMethod(setExpression);
            }
            try {
                setBody = this.generateSetter(context, newClass, pool, valueSetter, expression, root);
            }
            catch (UnsupportedCompilationException uc) {
                if (nodeMember == null) {
                    nodeMember = new CtField(nodeClass, "_node", newClass);
                    newClass.addField(nodeMember);
                }
                setBody = this.generateOgnlSetter(newClass, valueSetter, nodeMember);
                if (setExpression != null) break block9;
                setExpression = CtNewMethod.setter((String)"setExpression", (CtField)nodeMember);
                newClass.addMethod(setExpression);
            }
        }
        try {
            newClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)newClass));
            Class<?> clazz = this.instantiateClass(pool, newClass);
            newClass.detach();
            expression.setAccessor((ExpressionAccessor)clazz.newInstance());
            if (nodeMember != null) {
                expression.getAccessor().setExpression(expression);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error compiling expression on object " + root + " with expression node " + expression + " getter body: " + getBody + " setter body: " + setBody, t);
        }
    }

    protected Class<?> instantiateClass(ClassPool pool, CtClass newClass) throws CannotCompileException {
        return pool.toClass(newClass);
    }

    protected String generateGetter(OgnlContext context, CtClass newClass, ClassPool pool, CtMethod valueGetter, Node expression, Object root) throws Exception {
        String pre = "";
        String post = "";
        context.setRoot(root);
        context.remove(PRE_CAST);
        String getterCode = expression.toGetSourceString(context, root);
        if (getterCode == null || getterCode.trim().length() <= 0 && !ASTVarRef.class.isAssignableFrom(expression.getClass())) {
            getterCode = "null";
        }
        String castExpression = (String)context.get(PRE_CAST);
        if (context.getCurrentType() == null || context.getCurrentType().isPrimitive() || Character.class.isAssignableFrom(context.getCurrentType()) || Object.class == context.getCurrentType()) {
            pre = pre + " ($w) (";
            post = post + ")";
        }
        String rootExpr = !getterCode.equals("null") ? ExpressionCompiler.getRootExpression(expression, root, context) : "";
        String noRoot = (String)context.remove("_noRoot");
        if (noRoot != null) {
            rootExpr = "";
        }
        this.createLocalReferences(context, pool, newClass, valueGetter.getParameterTypes());
        String body = expression instanceof OrderedReturn && ((OrderedReturn)((Object)expression)).getLastExpression() != null ? "{ " + (expression instanceof ASTMethod || expression instanceof ASTChain ? rootExpr : "") + (castExpression != null ? castExpression : "") + ((OrderedReturn)((Object)expression)).getCoreExpression() + " return " + pre + ((OrderedReturn)((Object)expression)).getLastExpression() + post + ";}" : "{  return " + pre + (castExpression != null ? castExpression : "") + rootExpr + getterCode + post + ";}";
        if (body.contains("..")) {
            body = body.replaceAll("\\.\\.", ".");
        }
        valueGetter.setBody(body);
        newClass.addMethod(valueGetter);
        return body;
    }

    @Override
    public String createLocalReference(OgnlContext context, String expression, Class<?> type) {
        String referenceName = "ref" + context.incrementLocalReferenceCounter();
        context.addLocalReference(referenceName, new OgnlLocalReference(referenceName, expression, type));
        String castString = "";
        if (!type.isPrimitive()) {
            castString = "(" + ExpressionCompiler.getCastString(type) + ") ";
        }
        return castString + referenceName + "($$)";
    }

    private void createLocalReferences(OgnlContext context, ClassPool pool, CtClass clazz, CtClass[] params) throws CannotCompileException, NotFoundException {
        Map<String, LocalReference> referenceMap = context.getLocalReferences();
        if (referenceMap == null || referenceMap.size() < 1) {
            return;
        }
        Iterator<LocalReference> it = referenceMap.values().iterator();
        while (it.hasNext()) {
            LocalReference ref = it.next();
            String widener = ref.getType().isPrimitive() ? " " : " ($w) ";
            String body = "{";
            body = body + " return  " + widener + ref.getExpression() + ";";
            if ((body = body + "}").contains("..")) {
                body = body.replaceAll("\\.\\.", ".");
            }
            CtMethod method = new CtMethod(pool.get(ExpressionCompiler.getCastString(ref.getType())), ref.getName(), params, clazz);
            method.setBody(body);
            clazz.addMethod(method);
            it.remove();
        }
    }

    protected String generateSetter(OgnlContext context, CtClass newClass, ClassPool pool, CtMethod valueSetter, Node expression, Object root) throws Exception {
        if (expression instanceof ExpressionNode || expression instanceof ASTConst) {
            throw new UnsupportedCompilationException("Can't compile expression/constant setters.");
        }
        context.setRoot(root);
        context.remove(PRE_CAST);
        String setterCode = expression.toSetSourceString(context, root);
        String castExpression = (String)context.get(PRE_CAST);
        if (setterCode == null || setterCode.trim().length() < 1) {
            throw new UnsupportedCompilationException("Can't compile null setter body.");
        }
        if (root == null) {
            throw new UnsupportedCompilationException("Can't compile setters with a null root object.");
        }
        String pre = ExpressionCompiler.getRootExpression(expression, root, context);
        String noRoot = (String)context.remove("_noRoot");
        if (noRoot != null) {
            pre = "";
        }
        this.createLocalReferences(context, pool, newClass, valueSetter.getParameterTypes());
        String body = "{" + (castExpression != null ? castExpression : "") + pre + setterCode + ";}";
        if (body.contains("..")) {
            body = body.replaceAll("\\.\\.", ".");
        }
        valueSetter.setBody(body);
        newClass.addMethod(valueSetter);
        return body;
    }

    protected String generateOgnlGetter(CtClass clazz, CtMethod valueGetter, CtField node) throws Exception {
        String body = "return " + node.getName() + ".getValue($1, $2);";
        valueGetter.setBody(body);
        clazz.addMethod(valueGetter);
        return body;
    }

    protected String generateOgnlSetter(CtClass clazz, CtMethod valueSetter, CtField node) throws Exception {
        String body = node.getName() + ".setValue($1, $2, $3);";
        valueSetter.setBody(body);
        clazz.addMethod(valueSetter);
        return body;
    }

    protected EnhancedClassLoader getClassLoader(OgnlContext context) {
        EnhancedClassLoader ret = this.loaders.get(context.getClassResolver());
        if (ret != null) {
            return ret;
        }
        ContextClassLoader classLoader = new ContextClassLoader(OgnlContext.class.getClassLoader(), context);
        ret = new EnhancedClassLoader(classLoader);
        this.loaders.put(context.getClassResolver(), ret);
        return ret;
    }

    protected CtClass getCtClass(Class<?> searchClass) throws NotFoundException {
        return this.classPool.get(searchClass.getName());
    }

    protected ClassPool getClassPool(OgnlContext context, EnhancedClassLoader loader) {
        if (this.classPool != null) {
            return this.classPool;
        }
        this.classPool = ClassPool.getDefault();
        this.classPool.insertClassPath((ClassPath)new LoaderClassPath(loader.getParent()));
        return this.classPool;
    }
}

