/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class MethodMonitorAspect {
    private static final Logger LOG = LoggerFactory.getLogger(MethodMonitorAspect.class);
    private MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ MethodMonitorAspect ajc$perSingletonInstance;

    public MethodMonitorAspect() {
        if (this.metricsSystem != null) {
            LOG.info("MethodMonitorAspect initialized.");
        } else {
            LOG.warn("MetricsSystem is not initialized, MethodMonitorAspect is disabled.");
        }
    }

    @Pointcut(value="execution(@org.apache.gravitino.metrics.Monitored * *(..))")
    public void monitoredMethods() {
    }

    @Around(value="monitoredMethods() && @annotation(monitored)")
    public Object monitorMethod(ProceedingJoinPoint pjp, Monitored monitored) throws Throwable {
        Object object;
        block10: {
            if (this.metricsSystem == null) {
                return pjp.proceed();
            }
            MetricsSource metricsSource = this.metricsSystem.getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.LOG.warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                return pjp.proceed();
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                Object result = pjp.proceed();
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    static {
        try {
            MethodMonitorAspect.ajc$perSingletonInstance = new MethodMonitorAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static MethodMonitorAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.gravitino.metrics.MethodMonitorAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

