/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.casbin.jcasbin.rbac.DefaultRoleManager;
import org.casbin.jcasbin.rbac.Role;

public class ConditionalRoleManager
extends DefaultRoleManager {
    public ConditionalRoleManager(int maxHierarchyLevel) {
        super(maxHierarchyLevel);
    }

    public ConditionalRoleManager(int maxHierarchyLevel, BiPredicate<String, String> matchingFunc, BiPredicate<String, String> domainMatchingFunc) {
        super(maxHierarchyLevel, matchingFunc, domainMatchingFunc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasLink(String name1, String name2, String ... domains) {
        if (name1.equals(name2) || this.matchingFunc != null && this.matchingFunc.test(name1, name2)) {
            return true;
        }
        boolean userCreated = !this.allRoles.containsKey(name1);
        boolean roleCreated = !this.allRoles.containsKey(name2);
        Role user = this.getRole(name1);
        Role role = this.getRole(name2);
        HashMap<String, Role> roles = new HashMap<String, Role>();
        roles.put(user.getName(), user);
        try {
            boolean bl = this.hasLinkHelper(role.getName(), roles, this.maxHierarchyLevel, domains);
            return bl;
        }
        finally {
            if (userCreated) {
                this.removeRole(user.getName());
            }
            if (roleCreated) {
                this.removeRole(role.getName());
            }
        }
    }

    public boolean hasLinkHelper(String targetName, Map<String, Role> roles, int level, final String ... domains) {
        if (level < 0 || roles.isEmpty()) {
            return false;
        }
        final HashMap<String, Role> nextRoles = new HashMap<String, Role>();
        for (final Role role : roles.values()) {
            if (targetName.equals(role.getName()) || this.matchingFunc != null && this.match(role.getName(), targetName)) {
                return true;
            }
            role.rangeRoles((Consumer<? super Role>)new Consumer<Role>(){

                @Override
                public void accept(Role nextRole) {
                    ConditionalRoleManager.this.getNextRoles(role, nextRole, domains, nextRoles);
                }
            });
        }
        return this.hasLinkHelper(targetName, nextRoles, level - 1, domains);
    }

    public boolean getNextRoles(Role currentRole, Role nextRole, String[] domains, Map<String, Role> nextRoles) {
        boolean passLinkConditionFunc = true;
        Throwable err = null;
        if (domains.length == 0) {
            Function<String[], Boolean> linkConditionFunc = this.getLinkConditionFunc(currentRole.getName(), nextRole.getName());
            if (linkConditionFunc != null) {
                List<String> params = this.getLinkConditionFuncParams(currentRole.getName(), nextRole.getName(), domains);
                try {
                    passLinkConditionFunc = linkConditionFunc.apply(params.toArray(new String[0]));
                }
                catch (Exception e) {
                    err = e;
                }
            }
        } else {
            Function<String[], Boolean> linkConditionFunc = this.getDomainLinkConditionFunc(currentRole.getName(), nextRole.getName(), domains[0]);
            if (linkConditionFunc != null) {
                List<String> params = this.getLinkConditionFuncParams(currentRole.getName(), nextRole.getName(), domains);
                try {
                    passLinkConditionFunc = linkConditionFunc.apply(params.toArray(new String[0]));
                }
                catch (Exception e) {
                    err = e;
                }
            }
        }
        if (err != null) {
            System.err.println("hasLinkHelper LinkCondition Error");
            err.printStackTrace();
            return false;
        }
        if (passLinkConditionFunc) {
            nextRoles.put(nextRole.getName(), nextRole);
        }
        return true;
    }

    public Function<String[], Boolean> getLinkConditionFunc(String userName, String roleName) {
        return this.getDomainLinkConditionFunc(userName, roleName, "");
    }

    public Function<String[], Boolean> getDomainLinkConditionFunc(String userName, String roleName, String domain) {
        Role user = this.getRole(userName);
        Role role = this.getRole(roleName);
        if (user == null) {
            return null;
        }
        if (role == null) {
            return null;
        }
        return user.getLinkConditionFunc(role, domain);
    }

    public List<String> getLinkConditionFuncParams(String userName, String roleName, String[] domain) {
        String[] params;
        boolean userCreated = !this.allRoles.containsKey(userName);
        boolean roleCreated = !this.allRoles.containsKey(roleName);
        Role user = this.getRole(userName);
        Role role = this.getRole(roleName);
        if (userCreated) {
            this.removeRole(user.getName());
        }
        if (roleCreated) {
            this.removeRole(role.getName());
        }
        String domainName = "";
        if (domain.length != 0) {
            domainName = domain[0];
        }
        if ((params = user.getLinkConditionFuncParams(role, domainName)) != null) {
            return Arrays.asList(params);
        }
        return null;
    }

    public void addLinkConditionFunc(String userName, String roleName, Function<String[], Boolean> fn) {
        this.addDomainLinkConditionFunc(userName, roleName, "", fn);
    }

    public void addDomainLinkConditionFunc(String userName, String roleName, String domain, Function<String[], Boolean> fn) {
        Role user = this.getRole(userName);
        Role role = this.getRole(roleName);
        user.addLinkConditionFunc(role, domain, fn);
    }

    public void setLinkConditionFuncParams(String userName, String roleName, String ... params) {
        this.setDomainLinkConditionFuncParams(userName, roleName, "", params);
    }

    public void setDomainLinkConditionFuncParams(String userName, String roleName, String domain, String ... params) {
        Role user = this.getRole(userName);
        Role role = this.getRole(roleName);
        user.setLinkConditionFuncParams(role, domain, params);
    }
}

