/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.lancedb.lance.namespace.model.JsonArrowField;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"fields", "metadata"})
public class JsonArrowSchema {
    public static final String JSON_PROPERTY_FIELDS = "fields";
    @Nonnull
    private List<JsonArrowField> fields = new ArrayList<JsonArrowField>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();

    public JsonArrowSchema fields(@Nonnull List<JsonArrowField> fields) {
        this.fields = fields;
        return this;
    }

    public JsonArrowSchema addFieldsItem(JsonArrowField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<JsonArrowField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<JsonArrowField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFields(@Nonnull List<JsonArrowField> fields) {
        this.fields = fields;
    }

    public JsonArrowSchema metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonArrowSchema putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArrowSchema jsonArrowSchema = (JsonArrowSchema)o;
        return Objects.equals(this.fields, jsonArrowSchema.fields) && Objects.equals(this.metadata, jsonArrowSchema.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonArrowSchema {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getFields() != null) {
            for (int i = 0; i < this.getFields().size(); ++i) {
                if (this.getFields().get(i) == null) continue;
                joiner.add(this.getFields().get(i).toUrlQueryString(String.format("%sfields%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMetadata() != null) {
            for (String _key : this.getMetadata().keySet()) {
                try {
                    joiner.add(String.format("%smetadata%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getMetadata().get(_key), URLEncoder.encode(String.valueOf(this.getMetadata().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

