/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.lancedb.lance.namespace.model.IndexContent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"indexes", "page_token"})
public class ListTableIndicesResponse {
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    @Nonnull
    private List<IndexContent> indexes = new ArrayList<IndexContent>();
    public static final String JSON_PROPERTY_PAGE_TOKEN = "page_token";
    @Nullable
    private String pageToken;

    public ListTableIndicesResponse indexes(@Nonnull List<IndexContent> indexes) {
        this.indexes = indexes;
        return this;
    }

    public ListTableIndicesResponse addIndexesItem(IndexContent indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<IndexContent>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IndexContent> getIndexes() {
        return this.indexes;
    }

    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIndexes(@Nonnull List<IndexContent> indexes) {
        this.indexes = indexes;
    }

    public ListTableIndicesResponse pageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTableIndicesResponse listTableIndicesResponse = (ListTableIndicesResponse)o;
        return Objects.equals(this.indexes, listTableIndicesResponse.indexes) && Objects.equals(this.pageToken, listTableIndicesResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.indexes, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTableIndicesResponse {\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getIndexes() != null) {
            for (int i = 0; i < this.getIndexes().size(); ++i) {
                if (this.getIndexes().get(i) == null) continue;
                joiner.add(this.getIndexes().get(i).toUrlQueryString(String.format("%sindexes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getPageToken() != null) {
            try {
                joiner.add(String.format("%spage_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageToken()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

