/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;

public class AnnotationUtils {
    public static boolean hasAnnotationOfType(AnnotatedNode annotatedNode, String typeOrPackageName) {
        for (AnnotationNode annotation : annotatedNode.getAnnotations()) {
            if (!annotation.getClassNode().getName().startsWith(typeOrPackageName)) continue;
            return true;
        }
        return false;
    }

    public static List<AnnotationNode> getAnnotationNodeInHierarchyWithMetaAnnotation(ClassNode type, ClassNode anno) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        for (AnnotationNode annotation : type.getAnnotations()) {
            if (annotation.getClassNode().getAnnotations(anno).isEmpty()) continue;
            result.add(annotation);
        }
        if (result.isEmpty() && type.getSuperClass() != null) {
            return AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), anno);
        }
        return result;
    }

    public static List<AnnotationNode> getAnnotationNodeInHierarchyWithMetaAnnotation(ClassNode type, MethodNode originMethodNode, ClassNode metaAnnotationClassNode) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        while (type != null) {
            MethodNode methodNode = type.getMethod(originMethodNode.getName(), originMethodNode.getParameters());
            if (methodNode != null) {
                for (AnnotationNode annotation : methodNode.getAnnotations()) {
                    if (annotation.getClassNode().getAnnotations(metaAnnotationClassNode).isEmpty()) continue;
                    result.add(annotation);
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            type = type.getSuperClass();
        }
        return result;
    }

    public static List<AnnotationNode> hasMetaAnnotations(AnnotatedNode annotatedNode, String metaAnnotationClassName) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        HashMap<ClassNode, Boolean> seen = new HashMap<ClassNode, Boolean>();
        ClassNode type = ClassHelper.makeWithoutCaching((String)metaAnnotationClassName);
        for (AnnotationNode annotationNode : annotatedNode.getAnnotations()) {
            if (!AnnotationUtils.hasMetaAnnotation(annotationNode.getClassNode(), type, seen)) continue;
            result.add(annotationNode);
        }
        return result;
    }

    private static boolean hasMetaAnnotation(ClassNode annotationType, ClassNode metaAnnotationType, Map<ClassNode, Boolean> cache) {
        if (CandidateChecks.isRuntimeClass(annotationType)) {
            return false;
        }
        if (!cache.containsKey(annotationType)) {
            boolean result = false;
            if (!annotationType.getAnnotations(metaAnnotationType).isEmpty()) {
                result = true;
            } else {
                cache.put(annotationType, false);
                for (AnnotationNode annotationNode : annotationType.getAnnotations()) {
                    if (!AnnotationUtils.hasMetaAnnotation(annotationNode.getClassNode(), metaAnnotationType, cache)) continue;
                    result = true;
                    break;
                }
            }
            cache.put(annotationType, result);
        }
        return cache.get(annotationType);
    }
}

