/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.Timer;
import java.util.TimerTask;
import org.ojalgo.type.CalendarDateUnit;

public abstract class TypeCache<T> {
    private static final Timer TIMER = new Timer("TypeCache-Daemon", true);
    private volatile transient T myCachedObject;
    private volatile boolean myDirty;

    public TypeCache(long aPurgeIntervalMeassure, CalendarDateUnit aPurgeIntervalUnit) {
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                if (TypeCache.this.isDirty()) {
                    TypeCache.this.flushCache();
                } else {
                    TypeCache.this.makeDirty();
                }
            }
        }, 0L, aPurgeIntervalMeassure * aPurgeIntervalUnit.size());
    }

    private TypeCache() {
        this(8L, CalendarDateUnit.HOUR);
    }

    public final synchronized void flushCache() {
        this.myCachedObject = null;
    }

    public final synchronized T getCachedObject() {
        if (this.myCachedObject == null || this.myDirty) {
            this.myCachedObject = this.recreateCache();
            this.myDirty = false;
        }
        return this.myCachedObject;
    }

    public final synchronized boolean isCacheSet() {
        return this.myCachedObject != null;
    }

    public final synchronized boolean isDirty() {
        return this.myDirty;
    }

    public final synchronized void makeDirty() {
        this.myDirty = true;
    }

    protected abstract T recreateCache();
}

