/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.TimelineContext;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEventSubDoc;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineMetricSubDoc;

public class TimelineEntityDocument
implements TimelineDocument<TimelineEntityDocument> {
    private final TimelineEntity timelineEntity;
    private TimelineContext context;
    private String flowVersion;
    private String subApplicationUser;
    private final Map<String, Set<TimelineMetricSubDoc>> metrics = new HashMap<String, Set<TimelineMetricSubDoc>>();
    private final Map<String, Set<TimelineEventSubDoc>> events = new HashMap<String, Set<TimelineEventSubDoc>>();

    public TimelineEntityDocument() {
        this.timelineEntity = new TimelineEntity();
    }

    public TimelineEntityDocument(TimelineEntity timelineEntity) {
        this.timelineEntity = timelineEntity;
        this.transformEvents(timelineEntity.getEvents());
        this.timelineMetrics(timelineEntity.getMetrics());
    }

    private void timelineMetrics(Set<TimelineMetric> timelineMetrics) {
        for (TimelineMetric timelineMetric : timelineMetrics) {
            if (this.metrics.containsKey(timelineMetric.getId())) {
                this.metrics.get(timelineMetric.getId()).add(new TimelineMetricSubDoc(timelineMetric));
                continue;
            }
            HashSet<TimelineMetricSubDoc> metricSet = new HashSet<TimelineMetricSubDoc>();
            metricSet.add(new TimelineMetricSubDoc(timelineMetric));
            this.metrics.put(timelineMetric.getId(), metricSet);
        }
    }

    private void transformEvents(Set<TimelineEvent> timelineEvents) {
        for (TimelineEvent timelineEvent : timelineEvents) {
            if (this.events.containsKey(timelineEvent.getId())) {
                this.events.get(timelineEvent.getId()).add(new TimelineEventSubDoc(timelineEvent));
                continue;
            }
            HashSet<TimelineEventSubDoc> eventSet = new HashSet<TimelineEventSubDoc>();
            eventSet.add(new TimelineEventSubDoc(timelineEvent));
            this.events.put(timelineEvent.getId(), eventSet);
        }
    }

    @Override
    public void merge(TimelineEntityDocument newTimelineDocument) {
        if (newTimelineDocument.getCreatedTime() > 0L) {
            this.timelineEntity.setCreatedTime(Long.valueOf(newTimelineDocument.getCreatedTime()));
        }
        this.setMetrics(newTimelineDocument.getMetrics());
        this.setEvents(newTimelineDocument.getEvents());
        this.timelineEntity.getInfo().putAll(newTimelineDocument.getInfo());
        this.timelineEntity.getConfigs().putAll(newTimelineDocument.getConfigs());
        this.timelineEntity.getIsRelatedToEntities().putAll(newTimelineDocument.getIsRelatedToEntities());
        this.timelineEntity.getRelatesToEntities().putAll(newTimelineDocument.getRelatesToEntities());
    }

    @Override
    public String getId() {
        return this.timelineEntity.getId();
    }

    public void setId(String key) {
        this.timelineEntity.setId(key);
    }

    @Override
    public String getType() {
        return this.timelineEntity.getType();
    }

    public void setType(String type) {
        this.timelineEntity.setType(type);
    }

    public Map<String, Object> getInfo() {
        this.timelineEntity.getInfo().put("FROM_ID", this.getId());
        return this.timelineEntity.getInfo();
    }

    public void setInfo(Map<String, Object> info) {
        this.timelineEntity.setInfo(info);
    }

    public Map<String, Set<TimelineMetricSubDoc>> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Set<TimelineMetricSubDoc>> metrics) {
        for (Map.Entry<String, Set<TimelineMetricSubDoc>> metricEntry : metrics.entrySet()) {
            String metricId = metricEntry.getKey();
            Set<TimelineMetricSubDoc> metricValue = metricEntry.getValue();
            for (TimelineMetricSubDoc metricSubDoc : metricValue) {
                this.timelineEntity.addMetric(metricSubDoc.fetchTimelineMetric());
            }
            if (this.metrics.containsKey(metricId)) {
                this.metrics.get(metricId).addAll(metricValue);
                continue;
            }
            this.metrics.put(metricId, new HashSet<TimelineMetricSubDoc>(metricValue));
        }
    }

    public Map<String, Set<TimelineEventSubDoc>> getEvents() {
        return this.events;
    }

    public void setEvents(Map<String, Set<TimelineEventSubDoc>> events) {
        for (Map.Entry<String, Set<TimelineEventSubDoc>> eventEntry : events.entrySet()) {
            String eventId = eventEntry.getKey();
            Set<TimelineEventSubDoc> eventValue = eventEntry.getValue();
            for (TimelineEventSubDoc eventSubDoc : eventValue) {
                this.timelineEntity.addEvent(eventSubDoc.fetchTimelineEvent());
            }
            if (this.events.containsKey(eventId)) {
                this.events.get(eventId).addAll((Collection<TimelineEventSubDoc>)events.get(eventId));
                continue;
            }
            this.events.put(eventId, new HashSet<TimelineEventSubDoc>(eventValue));
        }
    }

    public Map<String, String> getConfigs() {
        return this.timelineEntity.getConfigs();
    }

    public void setConfigs(Map<String, String> configs) {
        this.timelineEntity.setConfigs(configs);
    }

    public Map<String, Set<String>> getIsRelatedToEntities() {
        return this.timelineEntity.getIsRelatedToEntities();
    }

    public void setIsRelatedToEntities(Map<String, Set<String>> isRelatedToEntities) {
        this.timelineEntity.setIsRelatedToEntities(isRelatedToEntities);
    }

    public Map<String, Set<String>> getRelatesToEntities() {
        return this.timelineEntity.getRelatesToEntities();
    }

    public void setRelatesToEntities(Map<String, Set<String>> relatesToEntities) {
        this.timelineEntity.setRelatesToEntities(relatesToEntities);
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public void setIdentifier(TimelineEntity.Identifier identifier) {
        this.timelineEntity.setIdentifier(identifier);
    }

    public void setIdPrefix(long idPrefix) {
        this.timelineEntity.setIdPrefix(idPrefix);
    }

    public String getSubApplicationUser() {
        return this.subApplicationUser;
    }

    public void setSubApplicationUser(String subApplicationUser) {
        this.subApplicationUser = subApplicationUser;
    }

    @Override
    public long getCreatedTime() {
        if (this.timelineEntity.getCreatedTime() == null) {
            return 0L;
        }
        return this.timelineEntity.getCreatedTime();
    }

    @Override
    public void setCreatedTime(long createdTime) {
        this.timelineEntity.setCreatedTime(Long.valueOf(createdTime));
    }

    public TimelineContext getContext() {
        return this.context;
    }

    public void setContext(TimelineContext context) {
        this.context = context;
    }

    public TimelineEntity fetchTimelineEntity() {
        return this.timelineEntity;
    }
}

