/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.exceptions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.stream.Stream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.InvalidObjectStateException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public enum ExceptionHandler {
    NO_SUCH_KEY(NoSuchKeyException.class, (cause, uri) -> ExceptionHandler.createFileNotFoundException("Object not found %s", uri)),
    INVALID_OBJECT_STATE(InvalidObjectStateException.class, (cause, uri) -> ExceptionHandler.createIOException("Object %s is in invalid state", uri, cause)),
    SDK_CLIENT(SdkClientException.class, (cause, uri) -> ExceptionHandler.createIOException("Client error accessing %s", uri, cause)),
    S3_SERVICE(S3Exception.class, (cause, uri) -> ExceptionHandler.createIOException("Server error accessing %s", uri, cause)),
    SDK_GENERAL(SdkException.class, (cause, uri) -> ExceptionHandler.createIOException("SDK error accessing %s", uri, cause));

    private final Class<? extends Exception> exceptionClass;
    private final ExceptionMapper mapper;

    private ExceptionHandler(Class<? extends Exception> exceptionClass, ExceptionMapper mapper) {
        this.exceptionClass = exceptionClass;
        this.mapper = mapper;
    }

    public static IOException toIOException(Throwable cause, S3URI uri) {
        return Stream.of(ExceptionHandler.values()).filter(handler -> handler.exceptionClass.isInstance(cause)).findFirst().map(handler -> handler.mapper.toIOException(cause, uri)).orElseGet(() -> ExceptionHandler.createIOException("Error accessing %s", uri, cause));
    }

    public static Exception[] getSampleExceptions() {
        return new Exception[]{(Exception)NoSuchKeyException.builder().build(), (Exception)InvalidObjectStateException.builder().build(), SdkClientException.builder().build(), S3Exception.builder().build(), SdkException.builder().build()};
    }

    private static IOException createIOException(String message, S3URI uri, Throwable cause) {
        return new IOException(String.format(message, uri), cause);
    }

    private static FileNotFoundException createFileNotFoundException(String message, S3URI uri) {
        return new FileNotFoundException(String.format(message, uri));
    }

    @FunctionalInterface
    private static interface ExceptionMapper {
        public IOException toIOException(Throwable var1, S3URI var2);
    }
}

