/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.management.model.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.shaded.org.terracotta.management.model.context.Contextual;
import org.apache.hadoop.shaded.org.terracotta.management.model.message.Message;
import org.apache.hadoop.shaded.org.terracotta.management.sequence.Sequence;

public class DefaultMessage
implements Message,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Contextual[] data;
    private final Sequence sequence;
    private final String messageType;

    public DefaultMessage(Sequence sequence, String messageType, Contextual ... data) {
        this.sequence = sequence;
        this.messageType = messageType;
        this.data = data;
    }

    @Override
    public <T extends Contextual> List<T> unwrap(Class<T> type) {
        return Arrays.asList(this.data);
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public long getTimestamp() {
        return this.sequence.getTimestamp();
    }

    @Override
    public String getType() {
        return this.messageType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.messageType + ", sequence=" + this.sequence + ", data=" + (this.data == null ? null : Arrays.deepToString(this.data)) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMessage that = (DefaultMessage)o;
        if (!this.sequence.equals(that.sequence)) {
            return false;
        }
        if (this.data.getClass() != that.data.getClass()) {
            return false;
        }
        if (!Arrays.equals(this.data, that.data)) {
            return false;
        }
        return this.messageType.equals(that.messageType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.data);
        result = 31 * result + this.sequence.hashCode();
        result = 31 * result + this.messageType.hashCode();
        return result;
    }
}

