/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionBuilder;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateBuilder;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.profiling.ExecutionDataProfile;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransformBaseFn
extends DoFn<HopRow, HopRow> {
    protected static final Logger LOG = LoggerFactory.getLogger(TransformBaseFn.class);
    protected String transformName;
    protected String parentLogChannelId;
    protected String runConfigName;
    protected String dataSamplersJson;
    protected transient SingleThreadedPipelineExecutor executor;
    protected transient ExecutionInfoLocation executionInfoLocation;
    protected transient List<IExecutionDataSampler> dataSamplers;
    protected transient List<IExecutionDataSamplerStore> dataSamplerStores;
    protected transient Timer executionInfoTimer;
    protected transient BoundedWindow batchWindow;

    public TransformBaseFn(String parentLogChannelId, String runConfigName, String dataSamplersJson) {
        this.parentLogChannelId = parentLogChannelId;
        this.runConfigName = runConfigName;
        this.dataSamplersJson = dataSamplersJson;
    }

    protected void sendSamplesToLocation(boolean finished) throws HopException {
        if (this.executor == null) {
            return;
        }
        Pipeline pipeline = this.executor.getPipeline();
        if (pipeline == null) {
            return;
        }
        String logChannelId = pipeline.getLogChannelId();
        ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.of().withOwnerId(logChannelId).withParentId(this.parentLogChannelId).withExecutionType(ExecutionType.Transform).withCollectionDate(new Date()).withFinished(finished);
        for (IExecutionDataSamplerStore store : this.dataSamplerStores) {
            dataBuilder.addDataSets(store.getSamples()).addSetMeta(store.getSamplesMetadata());
        }
        ITransform transform = pipeline.findRunThread(this.transformName);
        dataBuilder.addSetMeta(logChannelId, new ExecutionDataSetMeta(logChannelId, logChannelId, this.transformName, logChannelId, this.transformName + "." + logChannelId + " (Metrics)"));
        dataBuilder.addDataSet(logChannelId, new RowBuffer(new RowMetaBuilder().addString("metric").addInteger("value").build(), List.of(new Object[]{"input", transform.getLinesInput()}, new Object[]{"output", transform.getLinesOutput()}, new Object[]{"read", transform.getLinesRead()}, new Object[]{"written", transform.getLinesWritten()}, new Object[]{"rejected", transform.getLinesRejected()}, new Object[]{"error", transform.getErrors()})));
        IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
        iLocation.registerData(dataBuilder.build());
        IEngineComponent transformComponent = (IEngineComponent)pipeline.getComponentCopies(this.transformName).get(0);
        ExecutionState transformState = ExecutionStateBuilder.fromTransform((IPipelineEngine)pipeline, (IEngineComponent)transformComponent).build();
        transformState.setParentId(this.parentLogChannelId);
        iLocation.updateExecutionState(transformState);
    }

    protected void lookupExecutionInformation(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException, JsonProcessingException {
        String profileName;
        ExecutionInfoLocation location;
        String locationName;
        this.executionInfoLocation = null;
        this.dataSamplers = new ArrayList<IExecutionDataSampler>();
        this.dataSamplerStores = new ArrayList<IExecutionDataSamplerStore>();
        PipelineRunConfiguration runConf = (PipelineRunConfiguration)metadataProvider.getSerializer(PipelineRunConfiguration.class).load(this.runConfigName);
        if (runConf != null && StringUtils.isNotEmpty((String)(locationName = runConf.getExecutionInfoLocationName())) && (location = (ExecutionInfoLocation)metadataProvider.getSerializer(ExecutionInfoLocation.class).load(locationName)) != null && StringUtils.isNotEmpty((String)(profileName = runConf.getExecutionDataProfileName()))) {
            ExecutionDataProfile dataProfile = (ExecutionDataProfile)metadataProvider.getSerializer(ExecutionDataProfile.class).load(profileName);
            if (dataProfile != null) {
                this.dataSamplers.addAll(dataProfile.getSamplers());
            }
            if (StringUtils.isNotEmpty((String)this.dataSamplersJson)) {
                IExecutionDataSampler[] extraSamplers = (IExecutionDataSampler[])HopJson.newMapper().readValue(this.dataSamplersJson, IExecutionDataSampler[].class);
                this.dataSamplers.addAll(Arrays.asList(extraSamplers));
            }
            this.executionInfoLocation = location;
            IExecutionInfoLocation iLocation = this.executionInfoLocation.getExecutionInfoLocation();
            iLocation.initialize(variables, metadataProvider);
        }
    }

    protected void attachExecutionSamplersToOutput(IVariables variables, String transformName, String logChannelId, IRowMeta inputRowMeta, IRowMeta outputRowMeta, ITransform transform) {
        if (this.executionInfoLocation != null && !this.dataSamplers.isEmpty()) {
            ExecutionDataSamplerMeta dataSamplerMeta = new ExecutionDataSamplerMeta(transformName, logChannelId, logChannelId, false, false);
            for (IExecutionDataSampler dataSampler : this.dataSamplers) {
                IExecutionDataSamplerStore dataSamplerStore = dataSampler.createSamplerStore(dataSamplerMeta);
                dataSamplerStore.init(variables, inputRowMeta, outputRowMeta);
                this.dataSamplerStores.add(dataSamplerStore);
            }
            transform.addRowListener((IRowListener)new RowAdapter(){

                public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                    for (int s = 0; s < TransformBaseFn.this.dataSamplers.size(); ++s) {
                        IExecutionDataSampler sampler = TransformBaseFn.this.dataSamplers.get(s);
                        IExecutionDataSamplerStore store = TransformBaseFn.this.dataSamplerStores.get(s);
                        try {
                            sampler.sampleRow(store, IStream.StreamType.OUTPUT, rowMeta, row);
                            continue;
                        }
                        catch (HopException e) {
                            throw new RuntimeException("Error sampling row", e);
                        }
                    }
                }
            });
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        TransformBaseFn.this.sendSamplesToLocation(false);
                    }
                    catch (HopException e) {
                        LOG.error("Error sending transform samples to location (non-fatal)", (Throwable)e);
                    }
                }
            };
            this.executionInfoTimer = new Timer(transformName);
            this.executionInfoTimer.schedule(task, Const.toLong((String)this.executionInfoLocation.getDataLoggingDelay(), (long)5000L), Const.toLong((String)this.executionInfoLocation.getDataLoggingInterval(), (long)10000L));
        }
    }

    protected void registerExecutingTransform(Pipeline pipeline) {
        if (this.executionInfoLocation == null) {
            return;
        }
        try {
            ITransform transform = pipeline.getTransform(this.transformName, 0);
            IEngineComponent transformComponent = (IEngineComponent)pipeline.getComponentCopies(this.transformName).get(0);
            Execution execution = ExecutionBuilder.fromTransform((IPipelineEngine)pipeline, (ITransform)transform).build();
            execution.setParentId(this.parentLogChannelId);
            this.executionInfoLocation.getExecutionInfoLocation().registerExecution(execution);
            ExecutionState transformState = ExecutionStateBuilder.fromTransform((IPipelineEngine)pipeline, (IEngineComponent)transformComponent).build();
            transformState.setParentId(this.parentLogChannelId);
            this.executionInfoLocation.getExecutionInfoLocation().updateExecutionState(transformState);
        }
        catch (Exception e) {
            LOG.error("Error updating transform execution state in location (non-fatal)", (Throwable)e);
        }
    }

    protected class TransformFinishBundleContext
    implements TupleOutputContext<HopRow> {
        private DoFn.FinishBundleContext context;
        private BoundedWindow batchWindow;

        public TransformFinishBundleContext(DoFn.FinishBundleContext context, BoundedWindow batchWindow) {
            this.context = context;
            this.batchWindow = batchWindow;
        }

        @Override
        public void output(TupleTag<HopRow> tupleTag, HopRow output) {
            this.context.output(tupleTag, (Object)output, Instant.now(), this.batchWindow);
        }
    }

    protected class TransformProcessContext
    implements TupleOutputContext<HopRow> {
        private DoFn.ProcessContext context;

        public TransformProcessContext(DoFn.ProcessContext processContext) {
            this.context = processContext;
        }

        @Override
        public void output(TupleTag<HopRow> tupleTag, HopRow output) {
            this.context.output(tupleTag, (Object)output);
        }
    }

    protected static interface TupleOutputContext<T> {
        public void output(TupleTag<T> var1, T var2);
    }
}

