/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.BufferedSinkJsonWriter;
import com.squareup.moshi.BufferedSourceJsonReader;
import java.io.Closeable;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

public abstract class JsonReader
implements Closeable {
    public static JsonReader of(BufferedSource source) {
        return new BufferedSourceJsonReader(source);
    }

    JsonReader() {
    }

    public abstract void setLenient(boolean var1);

    public abstract boolean isLenient();

    public abstract void setFailOnUnknown(boolean var1);

    public abstract boolean failOnUnknown();

    public abstract void beginArray() throws IOException;

    public abstract void endArray() throws IOException;

    public abstract void beginObject() throws IOException;

    public abstract void endObject() throws IOException;

    public abstract boolean hasNext() throws IOException;

    public abstract Token peek() throws IOException;

    public abstract String nextName() throws IOException;

    abstract int selectName(Options var1) throws IOException;

    public abstract String nextString() throws IOException;

    abstract int selectString(Options var1) throws IOException;

    public abstract boolean nextBoolean() throws IOException;

    public abstract <T> T nextNull() throws IOException;

    public abstract double nextDouble() throws IOException;

    public abstract long nextLong() throws IOException;

    public abstract int nextInt() throws IOException;

    public abstract void skipValue() throws IOException;

    public abstract String getPath();

    abstract void promoteNameToValue() throws IOException;

    public static enum Token {
        BEGIN_ARRAY,
        END_ARRAY,
        BEGIN_OBJECT,
        END_OBJECT,
        NAME,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL,
        END_DOCUMENT;

    }

    static final class Options {
        final String[] strings;
        final okio.Options doubleQuoteSuffix;

        private Options(String[] strings, okio.Options doubleQuoteSuffix) {
            this.strings = strings;
            this.doubleQuoteSuffix = doubleQuoteSuffix;
        }

        public static Options of(String ... strings) {
            try {
                ByteString[] result = new ByteString[strings.length];
                Buffer buffer = new Buffer();
                for (int i = 0; i < strings.length; ++i) {
                    BufferedSinkJsonWriter.string((BufferedSink)buffer, strings[i]);
                    buffer.readByte();
                    result[i] = buffer.readByteString();
                }
                return new Options((String[])strings.clone(), okio.Options.of((ByteString[])result));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

