/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.monetdbbulkloader;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.util.StreamLogger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbBulkLoaderData;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbBulkLoaderMeta;
import org.monetdb.mcl.io.BufferedMCLReader;
import org.monetdb.mcl.io.BufferedMCLWriter;
import org.monetdb.mcl.io.LineType;
import org.monetdb.mcl.net.MapiSocket;

public class MonetDbBulkLoader
extends BaseTransform<MonetDbBulkLoaderMeta, MonetDbBulkLoaderData> {
    private static final Class<?> PKG = MonetDbBulkLoaderMeta.class;
    private IRowMeta physicalTableRowMeta;
    private static final String ERROR_LOADING_DATA = "Error loading data: ";

    public MonetDbBulkLoader(TransformMeta transformMeta, MonetDbBulkLoaderMeta meta, MonetDbBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected String escapeOsPath(String path, boolean isWindows) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ' ') {
                sb.append(isWindows ? "^ " : "\\ ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(MonetDbBulkLoaderMeta meta) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Started execute");
        }
        try {
            MapiSocket mserver;
            if (this.isDetailed()) {
                this.logDetailed("Auto String Length flag: " + meta.isAutoStringWidths());
            }
            DatabaseMeta dm = meta.getDatabaseMeta();
            String user = this.resolve(Const.NVL((String)dm.getUsername(), (String)""));
            String password = Utils.resolvePassword((IVariables)this.variables, (String)Const.NVL((String)dm.getPassword(), (String)""));
            ((MonetDbBulkLoaderData)this.data).mserver = mserver = this.getMonetDBConnection();
            ((MonetDbBulkLoaderData)this.data).in = mserver.getReader();
            ((MonetDbBulkLoaderData)this.data).out = mserver.getWriter();
            String error = ((MonetDbBulkLoaderData)this.data).in.discardRemainder();
            if (error != null) {
                throw new HopException("Error while connecting to MonetDB for bulk loading : " + error);
            }
            ((MonetDbBulkLoaderData)this.data).outputLogger = new StreamLogger(this.getLogChannel(), mserver.getInputStream(), "OUTPUT");
            if (meta.isTruncate()) {
                this.truncate();
            }
            Database db = null;
            try {
                db = new Database(meta.getParent(), this.variables, dm);
                db.connect();
                this.physicalTableRowMeta = db.getTableFields(((MonetDbBulkLoaderData)this.data).schemaTable);
            }
            catch (Exception e) {
                try {
                    if (db != null) {
                        this.physicalTableRowMeta = db.getTableFields(meta.getTableName());
                    }
                }
                catch (Exception e1) {
                    this.logBasic("Could not get metadata for the physical table " + ((MonetDbBulkLoaderData)this.data).schemaTable + ".");
                }
            }
            finally {
                if (db != null) {
                    db.disconnect();
                }
            }
            meta.setCompatibilityDbVersionMode(this.variables);
        }
        catch (Exception ex) {
            throw new HopException((Throwable)ex);
        }
        return true;
    }

    public boolean processRow() throws HopException {
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (!this.first) {
                    try {
                        this.writeBufferToMonetDB(((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta());
                        ((MonetDbBulkLoaderData)this.data).out.flush();
                    }
                    finally {
                        ((MonetDbBulkLoaderData)this.data).mserver.close();
                    }
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                ((MonetDbBulkLoaderData)this.data).keynrs = new int[((MonetDbBulkLoaderMeta)this.meta).getFieldStream().length];
                for (int i = 0; i < ((MonetDbBulkLoaderData)this.data).keynrs.length; ++i) {
                    ((MonetDbBulkLoaderData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(((MonetDbBulkLoaderMeta)this.meta).getFieldStream()[i]);
                }
                this.execute((MonetDbBulkLoaderMeta)this.meta);
            }
            this.writeRowToMonetDB(this.getInputRowMeta(), r, ((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta());
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ErrorInTransform", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    protected void writeRowToMonetDB(IRowMeta rowMeta, Object[] r, DatabaseMeta dm) throws HopException {
        if (((MonetDbBulkLoaderData)this.data).bufferIndex == ((MonetDbBulkLoaderData)this.data).bufferSize || this.isDebug()) {
            this.writeBufferToMonetDB(dm);
        }
        this.addRowToBuffer(rowMeta, r);
    }

    protected void addRowToBuffer(IRowMeta rowMeta, Object[] r) throws HopException {
        StringBuilder line = new StringBuilder();
        try {
            for (int i = 0; i < ((MonetDbBulkLoaderData)this.data).keynrs.length; ++i) {
                if (i > 0) {
                    line.append(((MonetDbBulkLoaderData)this.data).separator);
                }
                int index = ((MonetDbBulkLoaderData)this.data).keynrs[i];
                IValueMeta valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                String nullRep = ((MonetDbBulkLoaderData)this.data).nullrepresentation;
                if (valueData != null) {
                    switch (valueMeta.getType()) {
                        case 2: {
                            String str = valueMeta.getString(valueData);
                            if (str == null || str.equals(nullRep)) {
                                line.append(str);
                                break;
                            }
                            line.append(((MonetDbBulkLoaderData)this.data).quote);
                            str = str.replace("\\", "\\\\");
                            str = str.replace("\"", "\\\"");
                            if (((MonetDbBulkLoaderMeta)this.meta).isAutoStringWidths()) {
                                int len = valueMeta.getLength();
                                if (len < 1) {
                                    len = 100;
                                }
                                if (str.length() > len) {
                                    str = str.substring(0, len);
                                }
                                line.append(str);
                            } else {
                                line.append(str);
                            }
                            line.append(((MonetDbBulkLoaderData)this.data).quote);
                            break;
                        }
                        case 5: {
                            if (valueMeta.isStorageBinaryString() && ((MonetDbBulkLoaderMeta)this.meta).getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            Long value = valueMeta.getInteger(valueData);
                            if (value == null) {
                                line.append(((MonetDbBulkLoaderData)this.data).nullrepresentation);
                                break;
                            }
                            line.append(value);
                            break;
                        }
                        case 3: 
                        case 9: {
                            Date value;
                            if (valueMeta.isStorageBinaryString() && ((MonetDbBulkLoaderMeta)this.meta).getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            IValueMeta colMeta = null;
                            if (this.physicalTableRowMeta != null) {
                                colMeta = this.physicalTableRowMeta.getValueMeta(index);
                            }
                            if ((value = valueMeta.getDate(valueData)) == null) {
                                line.append(((MonetDbBulkLoaderData)this.data).nullrepresentation);
                                break;
                            }
                            if (colMeta != null && colMeta.getOriginalColumnTypeName().equalsIgnoreCase("date")) {
                                line.append(((MonetDbBulkLoaderData)this.data).monetDateMeta.getString((Object)value));
                                break;
                            }
                            if (colMeta != null && colMeta.getOriginalColumnTypeName().equalsIgnoreCase("time")) {
                                line.append(((MonetDbBulkLoaderData)this.data).monetTimeMeta.getString((Object)value));
                                break;
                            }
                            line.append(((MonetDbBulkLoaderData)this.data).monetTimestampMeta.getString((Object)value));
                            break;
                        }
                        case 4: {
                            Boolean value = valueMeta.getBoolean(valueData);
                            if (value == null) {
                                line.append(((MonetDbBulkLoaderData)this.data).nullrepresentation);
                                break;
                            }
                            line.append(value);
                            break;
                        }
                        case 1: {
                            if (valueMeta.isStorageBinaryString() && ((MonetDbBulkLoaderMeta)this.meta).getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            Double dbl = valueMeta.getNumber(valueData);
                            if (dbl == null) {
                                line.append(((MonetDbBulkLoaderData)this.data).nullrepresentation);
                                break;
                            }
                            IValueMeta colMeta = null;
                            if (this.physicalTableRowMeta != null) {
                                colMeta = this.physicalTableRowMeta.getValueMeta(index);
                            }
                            ValueMetaInteger valueMetaInt = new ValueMetaInteger(valueMeta.getName());
                            Long precision = colMeta.getPrecision();
                            line.append(ValueDataUtil.round((IValueMeta)valueMeta, (Object)dbl, (IValueMeta)valueMetaInt, (Object)precision, (int)4));
                            break;
                        }
                        case 6: {
                            if (valueMeta.isStorageBinaryString() && ((MonetDbBulkLoaderMeta)this.meta).getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            BigDecimal bd = valueMeta.getBigNumber(valueData);
                            if (bd == null) {
                                line.append(((MonetDbBulkLoaderData)this.data).nullrepresentation);
                                break;
                            }
                            IValueMeta colMeta = null;
                            if (this.physicalTableRowMeta != null) {
                                colMeta = this.physicalTableRowMeta.getValueMeta(index);
                            }
                            ValueMetaInteger valueMetaInt = new ValueMetaInteger(valueMeta.getName());
                            Long precision = colMeta.getPrecision();
                            line.append(ValueDataUtil.round((IValueMeta)valueMeta, (Object)bd, (IValueMeta)valueMetaInt, (Object)precision, (int)4));
                            break;
                        }
                    }
                    continue;
                }
                line.append(((MonetDbBulkLoaderData)this.data).nullrepresentation);
            }
            line.append(((MonetDbBulkLoaderData)this.data).newline);
            ((MonetDbBulkLoaderData)this.data).rowBuffer[((MonetDbBulkLoaderData)this.data).bufferIndex] = line.toString();
            ++((MonetDbBulkLoaderData)this.data).bufferIndex;
        }
        catch (Exception e) {
            throw new HopException("Error serializing rows of data to the MonetDB API (MAPI).", (Throwable)e);
        }
    }

    public void truncate() throws HopException {
        String table = ((MonetDbBulkLoaderData)this.data).schemaTable;
        String truncateStatement = ((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta().getTruncateTableStatement(this.variables, ((MonetDbBulkLoaderMeta)this.meta).getSchemaName(), ((MonetDbBulkLoaderMeta)this.meta).getTableName());
        if (truncateStatement == null) {
            throw new HopException("Truncate table is not supported!");
        }
        String cmd = truncateStatement + ";";
        try {
            this.executeSql(cmd);
        }
        catch (Exception e) {
            throw new HopException("Error while truncating table " + table, (Throwable)e);
        }
    }

    public void drop() throws HopException {
        try {
            this.executeSql("drop table " + ((MonetDbBulkLoaderData)this.data).schemaTable);
        }
        catch (Exception e) {
            throw new HopException("Error while dropping table " + ((MonetDbBulkLoaderData)this.data).schemaTable, (Throwable)e);
        }
    }

    public void autoAdjustSchema(MonetDbBulkLoaderMeta meta) throws HopException {
        if (this.isDetailed()) {
            this.logDetailed("Attempting to auto adjust table structure");
        }
        this.drop();
        if (this.isDetailed()) {
            this.logDetailed("getTransMeta: " + String.valueOf(this.getTransformMeta()));
        }
        if (this.isDetailed()) {
            this.logDetailed("getTransformname: " + this.getTransformName());
        }
        SqlStatement statement = meta.getTableDdl(this.variables, this.getPipelineMeta(), this.getTransformName(), true, (MonetDbBulkLoaderData)this.data, true);
        if (this.isDetailed()) {
            this.logDetailed("Statement: " + String.valueOf(statement));
        }
        if (this.isDetailed() && statement != null) {
            this.logDetailed("Statement has SQL: " + statement.hasSql());
        }
        if (statement != null && statement.hasSql()) {
            String cmd = statement.getSql();
            try {
                this.executeSql(cmd);
            }
            catch (Exception e) {
                throw new HopException("Error while creating table " + ((MonetDbBulkLoaderData)this.data).schemaTable, (Throwable)e);
            }
        }
        if (this.isDetailed()) {
            this.logDetailed("Successfull");
        }
    }

    protected void writeBufferToMonetDB(DatabaseMeta dm) throws HopException {
        if (((MonetDbBulkLoaderData)this.data).bufferIndex == 0) {
            return;
        }
        try {
            StringBuilder cmdBuff = new StringBuilder();
            String nullRep = this.resolve(((MonetDbBulkLoaderMeta)this.meta).getNullRepresentation());
            if (nullRep == null) {
                nullRep = ((MonetDbBulkLoaderData)this.data).nullrepresentation;
            }
            cmdBuff.append("COPY ").append(((MonetDbBulkLoaderData)this.data).bufferIndex).append(" RECORDS INTO ").append(((MonetDbBulkLoaderData)this.data).schemaTable).append(" FROM STDIN USING DELIMITERS '").append(((MonetDbBulkLoaderData)this.data).separator).append("','" + Const.CR + "','").append(((MonetDbBulkLoaderData)this.data).quote).append("' NULL AS '" + nullRep + "';");
            String cmd = cmdBuff.toString();
            String sql = dm.getConnectSql();
            if (!Utils.isEmpty((CharSequence)sql) && !Const.onlySpaces((String)sql)) {
                String[] sqlStatements;
                for (String statement : sqlStatements = sql.split(";")) {
                    ((MonetDbBulkLoaderData)this.data).out.write(115);
                    ((MonetDbBulkLoaderData)this.data).out.write(this.resolve(statement));
                    if (this.isDetailed()) {
                        this.logDetailed(this.resolve(statement));
                    }
                    ((MonetDbBulkLoaderData)this.data).out.write(59);
                    ((MonetDbBulkLoaderData)this.data).out.newLine();
                }
            } else {
                ((MonetDbBulkLoaderData)this.data).out.write(115);
            }
            if (this.isDetailed()) {
                this.logDetailed(cmd);
            }
            ((MonetDbBulkLoaderData)this.data).out.write(cmdBuff.toString());
            ((MonetDbBulkLoaderData)this.data).out.newLine();
            for (int i = 0; i < ((MonetDbBulkLoaderData)this.data).bufferIndex; ++i) {
                String buffer = ((MonetDbBulkLoaderData)this.data).rowBuffer[i];
                ((MonetDbBulkLoaderData)this.data).out.write(buffer);
                if (!this.isRowLevel()) continue;
                this.logRowlevel(buffer);
            }
            String error = ((MonetDbBulkLoaderData)this.data).in.discardRemainder();
            if (error != null) {
                throw new HopException(ERROR_LOADING_DATA + error);
            }
            ((MonetDbBulkLoaderData)this.data).out.writeLine("");
            error = ((MonetDbBulkLoaderData)this.data).in.discardRemainder();
            if (error != null) {
                throw new HopException(ERROR_LOADING_DATA + error);
            }
            if (!((MonetDbBulkLoaderMeta)this.meta).isCompatibilityDbVersionMode()) {
                ((MonetDbBulkLoaderData)this.data).out.writeLine("");
                error = ((MonetDbBulkLoaderData)this.data).in.discardRemainder();
                if (error != null) {
                    throw new HopException(ERROR_LOADING_DATA + error);
                }
            }
            if (this.isRowLevel()) {
                this.logRowlevel(Const.CR);
            }
            ((MonetDbBulkLoaderData)this.data).bufferIndex = 0;
        }
        catch (Exception e) {
            throw new HopException("An error occurred writing data to the MonetDB API (MAPI) process", (Throwable)e);
        }
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MonetDbBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
            }
            catch (HopException ex) {
                this.logError(ex.getMessage());
                return false;
            }
            ((MonetDbBulkLoaderData)this.data).quote = this.resolve(((MonetDbBulkLoaderMeta)this.meta).getFieldEnclosure());
            ((MonetDbBulkLoaderData)this.data).separator = this.resolve(((MonetDbBulkLoaderMeta)this.meta).getFieldSeparator());
            String nulls = this.resolve(((MonetDbBulkLoaderMeta)this.meta).getNullRepresentation());
            ((MonetDbBulkLoaderData)this.data).nullrepresentation = nulls == null ? "" : nulls;
            ((MonetDbBulkLoaderData)this.data).newline = Const.CR;
            String encoding = this.resolve(((MonetDbBulkLoaderMeta)this.meta).getEncoding());
            ((MonetDbBulkLoaderData)this.data).monetDateMeta = new ValueMetaDate("dateMeta");
            ((MonetDbBulkLoaderData)this.data).monetDateMeta.setConversionMask("yyyy/MM/dd");
            ((MonetDbBulkLoaderData)this.data).monetDateMeta.setStringEncoding(encoding);
            ((MonetDbBulkLoaderData)this.data).monetTimestampMeta = new ValueMetaDate("timestampMeta");
            ((MonetDbBulkLoaderData)this.data).monetTimestampMeta.setConversionMask("yyyy/MM/dd HH:mm:ss");
            ((MonetDbBulkLoaderData)this.data).monetTimestampMeta.setStringEncoding(encoding);
            ((MonetDbBulkLoaderData)this.data).monetTimeMeta = new ValueMetaDate("timeMeta");
            ((MonetDbBulkLoaderData)this.data).monetTimeMeta.setConversionMask("HH:mm:ss");
            ((MonetDbBulkLoaderData)this.data).monetTimeMeta.setStringEncoding(encoding);
            ((MonetDbBulkLoaderData)this.data).monetNumberMeta = new ValueMetaNumber("numberMeta");
            ((MonetDbBulkLoaderData)this.data).monetNumberMeta.setConversionMask("#.#");
            ((MonetDbBulkLoaderData)this.data).monetNumberMeta.setGroupingSymbol(",");
            ((MonetDbBulkLoaderData)this.data).monetNumberMeta.setDecimalSymbol(".");
            ((MonetDbBulkLoaderData)this.data).monetNumberMeta.setStringEncoding(encoding);
            ((MonetDbBulkLoaderData)this.data).bufferSize = Const.toInt((String)this.resolve(((MonetDbBulkLoaderMeta)this.meta).getBufferSize()), (int)100000);
            ((MonetDbBulkLoaderData)this.data).rowBuffer = new String[((MonetDbBulkLoaderData)this.data).bufferSize];
            ((MonetDbBulkLoaderData)this.data).bufferIndex = 0;
            ((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta().setQuoteAllFields(((MonetDbBulkLoaderMeta)this.meta).isFullyQuoteSQL());
            String connectionName = ((MonetDbBulkLoaderMeta)this.meta).getDbConnectionName();
            if (!Utils.isEmpty((CharSequence)connectionName) && connectionName.startsWith("${") && connectionName.endsWith("}")) {
                ((MonetDbBulkLoaderMeta)this.meta).setDatabaseMeta(this.getPipelineMeta().findDatabase(this.resolve(connectionName), this.variables));
            }
            ((MonetDbBulkLoaderData)this.data).schemaTable = ((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta(this).getQuotedSchemaTableCombination(this.variables, ((MonetDbBulkLoaderMeta)this.meta).getSchemaName(), ((MonetDbBulkLoaderMeta)this.meta).getTableName());
            return true;
        }
        return false;
    }

    public MonetDbBulkLoaderData getData() {
        return (MonetDbBulkLoaderData)this.data;
    }

    protected MapiSocket getMonetDBConnection() throws Exception {
        if (this.meta == null) {
            throw new HopException("No metadata available to determine connection information from.");
        }
        DatabaseMeta dm = ((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta();
        String hostname = this.resolve(Const.NVL((String)dm.getHostname(), (String)""));
        String portnum = this.resolve(Const.NVL((String)dm.getPort(), (String)""));
        String user = this.resolve(Const.NVL((String)dm.getUsername(), (String)""));
        String password = Utils.resolvePassword((IVariables)this.variables, (String)Const.NVL((String)dm.getPassword(), (String)""));
        String db = this.resolve(Const.NVL((String)dm.getDatabaseName(), (String)""));
        return MonetDbBulkLoader.getMonetDBConnection(hostname, Integer.parseInt(portnum), user, password, db, this.getLogChannel());
    }

    protected static MapiSocket getMonetDBConnection(String host, int port, String user, String password, String db) throws Exception {
        return MonetDbBulkLoader.getMonetDBConnection(host, port, user, password, db, null);
    }

    protected static MapiSocket getMonetDBConnection(String host, int port, String user, String password, String db, ILogChannel log) throws Exception {
        MapiSocket mserver = new MapiSocket();
        mserver.setDatabase(db);
        mserver.setLanguage("sql");
        List warnings = mserver.connect(host, port, user, password);
        if (warnings != null) {
            for (Object warning : warnings) {
                if (log == null) continue;
                log.logBasic("MonetDB connection warning: " + String.valueOf(warning));
            }
        } else if (log != null) {
            log.logDebug("Successful MapiSocket connection to MonetDB established.");
        }
        return mserver;
    }

    protected void executeSql(String query) throws Exception {
        if (this.meta == null) {
            throw new HopException("No metadata available to determine connection information from.");
        }
        DatabaseMeta dm = ((MonetDbBulkLoaderMeta)this.meta).getDatabaseMeta();
        String hostname = this.resolve(Const.NVL((String)dm.getHostname(), (String)""));
        String portnum = this.resolve(Const.NVL((String)dm.getPort(), (String)""));
        String user = this.resolve(Const.NVL((String)dm.getUsername(), (String)""));
        String password = Utils.resolvePassword((IVariables)this.variables, (String)Const.NVL((String)dm.getPassword(), (String)""));
        String db = this.resolve(Const.NVL((String)dm.getDatabaseName(), (String)""));
        MonetDbBulkLoader.executeSql(query, hostname, Integer.parseInt(portnum), user, password, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeSql(String query, String host, int port, String user, String password, String db) throws Exception {
        try (MapiSocket mserver = null;){
            mserver = MonetDbBulkLoader.getMonetDBConnection(host, port, user, password, db);
            BufferedMCLReader in = mserver.getReader();
            BufferedMCLWriter out = mserver.getWriter();
            String error = in.discardRemainder();
            if (error != null) {
                throw new Exception("ERROR waiting for input reader: " + error);
            }
            out.write(115);
            out.write(query);
            out.write(59);
            out.newLine();
            out.writeLine("");
            while (in.getLine() != null) {
                in.advance();
                LineType type = in.getLineType();
                if (type == LineType.PROMPT) {
                    break;
                }
                switch (type) {
                    case ERROR: 
                    case RESULT: {
                        break;
                    }
                }
            }
        }
    }
}

