/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.redshift.bulkloader;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoader;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderData;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderField;

@Transform(id="RedshiftBulkLoader", image="redshiftbulkloader.svg", name="i18n::BaseTransform.TypeLongDesc.RedshiftBulkLoaderMessage", description="i18n::BaseTransform.TypeTooltipDesc.RedshiftBulkLoaderMessage", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", documentationUrl="/pipeline/transforms/redshift-bulkloader.html", isIncludeJdbcDrivers=true, classLoaderGroup="redshift", actionTransformTypes={ActionTransformType.OUTPUT, ActionTransformType.RDBMS})
public class RedshiftBulkLoaderMeta
extends BaseTransformMeta<RedshiftBulkLoader, RedshiftBulkLoaderData> {
    private static final Class<?> PKG = RedshiftBulkLoaderMeta.class;
    public static final String CSV_DELIMITER = ",";
    public static final String CSV_RECORD_DELIMITER = "\n";
    public static final String CSV_ESCAPE_CHAR = "\"";
    public static final String ENCLOSURE = "\"";
    @HopMetadataProperty(key="connection", injectionKey="CONNECTIONNAME", injectionKeyDescription="RedshiftBulkLoader.Injection.CONNECTIONNAME", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty(key="schema", injectionKey="SCHEMANAME", injectionKeyDescription="RedshiftBulkLoader.Injection.SCHEMANAME", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SCHEMA)
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TABLENAME", injectionKeyDescription="RedshiftBulkLoader.Injection.TABLENAME", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TABLE)
    private String tablename;
    @HopMetadataProperty(key="use_credentials", injectionKey="USE_CREDENTIALS", injectionKeyDescription="")
    private boolean useCredentials;
    @HopMetadataProperty(key="use_system_env_vars", injectionKey="USE_SYSTEM_ENV_VARS", injectionKeyDescription="")
    private boolean useSystemEnvVars;
    @HopMetadataProperty(key="aws_access_key_id", injectionKey="AWS_ACCESS_KEY_ID", injectionKeyDescription="")
    private String awsAccessKeyId;
    @HopMetadataProperty(key="aws_secret_access_key", injectionKey="AWS_SECRET_ACCESS_KEY", injectionKeyDescription="")
    private String awsSecretAccessKey;
    @HopMetadataProperty(key="use_aws_iam_role", injectionKey="USE_AWS_IAM_ROLE", injectionKeyDescription="")
    private boolean useAwsIamRole;
    @HopMetadataProperty(key="aws_iam_role", injectionKey="AWS_IAM_ROLE", injectionKeyDescription="")
    private String awsIamRole;
    @HopMetadataProperty(key="truncate", injectionKey="TRUNCATE_TABLE", injectionKeyDescription="RedshiftBulkLoader.Injection.TruncateTable.Field", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TRUNCATE)
    private boolean truncateTable;
    @HopMetadataProperty(key="only_when_have_rows", injectionKey="ONLY_WHEN_HAVE_ROWS", injectionKeyDescription="RedshiftBulkLoader.Inject.OnlyWhenHaveRows.Field")
    private boolean onlyWhenHaveRows;
    @HopMetadataProperty(key="stream_to_s3", injectionKey="STREAM_TO_S3", injectionKeyDescription="")
    private boolean streamToS3Csv = true;
    @HopMetadataProperty(key="trim_whitespace", injectionKeyDescription="")
    private boolean trimWhitespace;
    @HopMetadataProperty(key="null_if", injectionKeyDescription="")
    private String nullIf;
    @HopMetadataProperty(key="error_column_mismatch", injectionKeyDescription="")
    private boolean errorColumnMismatch;
    @HopMetadataProperty(key="strip_null", injectionKeyDescription="")
    private boolean stripNull;
    @HopMetadataProperty(key="load_from_existing_file", injectionKey="LOAD_FROM_EXISTING_FILE", injectionKeyDescription="")
    private String loadFromExistingFileFormat;
    @HopMetadataProperty(key="specify_fields", injectionKeyDescription="")
    private boolean specifyFields;
    @HopMetadataProperty(key="load_from_filename", injectionKey="LOAD_FROM_FILENAME", injectionKeyDescription="")
    private String copyFromFilename;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="RedshiftBulkLoader.Injection.FIELDS", injectionKey="FIELDSTREAM", injectionKeyDescription="RedshiftBulkLoader.Injection.FIELDSTREAM", hopMetadataPropertyType=HopMetadataPropertyType.FIELD_LIST)
    private List<RedshiftBulkLoaderField> fields = new ArrayList<RedshiftBulkLoaderField>();
    @HopMetadataProperty(injectionKey="FIELDDATABASE", injectionKeyDescription="RedshiftBulkLoader.Injection.FIELDDATABASE")
    private String[] fieldDatabase;

    public Object clone() {
        return super.clone();
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public DatabaseMeta getDatabaseMeta() {
        return null;
    }

    @Deprecated(since="2.10")
    public String getTablename() {
        return this.getTableName();
    }

    public String getTableName() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public boolean isOnlyWhenHaveRows() {
        return this.onlyWhenHaveRows;
    }

    public void setOnlyWhenHaveRows(boolean onlyWhenHaveRows) {
        this.onlyWhenHaveRows = onlyWhenHaveRows;
    }

    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    public boolean isStreamToS3Csv() {
        return this.streamToS3Csv;
    }

    public void setStreamToS3Csv(boolean streamToS3Csv) {
        this.streamToS3Csv = streamToS3Csv;
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public String getNullIf() {
        return this.nullIf;
    }

    public void setNullIf(String nullIf) {
        this.nullIf = nullIf;
    }

    public boolean isErrorColumnMismatch() {
        return this.errorColumnMismatch;
    }

    public void setErrorColumnMismatch(boolean errorColumnMismatch) {
        this.errorColumnMismatch = errorColumnMismatch;
    }

    public boolean isStripNull() {
        return this.stripNull;
    }

    public void setStripNull(boolean stripNull) {
        this.stripNull = stripNull;
    }

    public String getLoadFromExistingFileFormat() {
        return this.loadFromExistingFileFormat;
    }

    public void setLoadFromExistingFileFormat(String loadFromExistingFileFormat) {
        this.loadFromExistingFileFormat = loadFromExistingFileFormat;
    }

    public String getCopyFromFilename() {
        return this.copyFromFilename;
    }

    public void setCopyFromFilename(String copyFromFilename) {
        this.copyFromFilename = copyFromFilename;
    }

    public List<RedshiftBulkLoaderField> getFields() {
        return this.fields;
    }

    public void setFields(List<RedshiftBulkLoaderField> fields) {
        this.fields = fields;
    }

    public boolean specifyFields() {
        return this.specifyFields;
    }

    public boolean isSpecifyFields() {
        return this.specifyFields;
    }

    public boolean isUseCredentials() {
        return this.useCredentials;
    }

    public void setUseCredentials(boolean useCredentials) {
        this.useCredentials = useCredentials;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public boolean isUseAwsIamRole() {
        return this.useAwsIamRole;
    }

    public void setUseAwsIamRole(boolean useAwsIamRole) {
        this.useAwsIamRole = useAwsIamRole;
    }

    public String getAwsIamRole() {
        return this.awsIamRole;
    }

    public void setAwsIamRole(String awsIamRole) {
        this.awsIamRole = awsIamRole;
    }

    public boolean isUseSystemEnvVars() {
        return this.useSystemEnvVars;
    }

    public void setUseSystemEnvVars(boolean useSystemEnvVars) {
        this.useSystemEnvVars = useSystemEnvVars;
    }

    public void setDefault() {
        this.tablename = "";
        this.specifyFields = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        block34: {
            Database db = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                if (databaseMeta != null) {
                    CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.ConnectionOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        if (!StringUtil.isEmpty((String)this.tablename)) {
                            String realTableName;
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, db.resolve(this.schemaName), db.resolve(this.tablename));
                            String realSchemaName = db.resolve(this.schemaName);
                            if (db.checkTableExists(realSchemaName, realTableName = db.resolve(this.tablename))) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                                IRowMeta r = db.getTableFields(schemaTable);
                                if (r != null) {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                    Object error_message = "";
                                    boolean error_found = false;
                                    if (prev != null && !prev.isEmpty()) {
                                        int idx;
                                        int i;
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                        if (!this.specifyFields()) {
                                            for (i = 0; i < prev.size(); ++i) {
                                                IValueMeta pv = prev.getValueMeta(i);
                                                idx = r.indexOfValue(pv.getName());
                                                if (idx >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{error_message});
                                                cr = new CheckResult(4, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        } else {
                                            for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                                int idx2 = r.indexOfValue(this.getFieldDatabase()[i]);
                                                if (idx2 >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + this.getFieldDatabase()[i] + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.FieldsSpecifiedNotInTable", (String[])new String[]{error_message});
                                                cr = new CheckResult(4, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        }
                                        error_message = "";
                                        if (!this.specifyFields()) {
                                            for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                                IValueMeta rv = r.getValueMeta(i);
                                                idx = prev.indexOfValue(rv.getName());
                                                if (idx >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                                                cr = new CheckResult(3, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        } else {
                                            for (i = 0; i < this.fields.size(); ++i) {
                                                RedshiftBulkLoaderField vbf = this.fields.get(i);
                                                idx = prev.indexOfValue(vbf.getStreamField());
                                                if (idx >= 0) continue;
                                                error_message = (String)error_message + "\t\t" + vbf.getStreamField() + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.FieldsSpecifiedNotFound", (String[])new String[]{error_message});
                                                cr = new CheckResult(4, (String)error_message, (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        }
                                    } else {
                                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                } else {
                                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                            } else {
                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                            }
                        } else {
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.NoTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                        }
                        break block34;
                    }
                    catch (HopException e) {
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        break block34;
                    }
                    finally {
                        db.disconnect();
                    }
                }
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.NoConnection", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (prev != null) {
                for (int i = 0; i < prev.size(); ++i) {
                    IValueMeta v = prev.getValueMeta(i);
                    DatabaseImpact ii = new DatabaseImpact(2, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tablename, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
        SqlStatement retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
        if (databaseMeta != null) {
            if (prev != null && !prev.isEmpty()) {
                if (!StringUtil.isEmpty((String)this.tablename)) {
                    Database db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tablename);
                        String cr_table = db.getDDL(schemaTable, prev);
                        if (Utils.isEmpty((CharSequence)cr_table)) {
                            cr_table = null;
                        }
                        retval.setSql(cr_table);
                    }
                    catch (HopDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tablename);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            if (StringUtil.isEmpty((String)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String[] getFieldDatabase() {
        return this.fieldDatabase;
    }

    public void setFieldDatabase(String[] fieldDatabase) {
        this.fieldDatabase = fieldDatabase;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

