/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PublisherAssembler {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private final @UnknownKeyFor @NonNull @Initialized PublisherOptions options;

    PublisherAssembler(@UnknownKeyFor @NonNull @Initialized PublisherOptions options) {
        this.options = options;
    }

    private @UnknownKeyFor @NonNull @Initialized AdminClient newAdminClient() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        try {
            return AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setServiceClient(AdminServiceClient.create((AdminServiceSettings)((AdminServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.topicPath().location().extractRegion(), (ClientSettings.Builder)AdminServiceSettings.newBuilder())))).setRegion(this.options.topicPath().location().extractRegion()).build());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized PublisherServiceClient newServiceClient() {
        try {
            return PublisherServiceClient.create((PublisherServiceSettings)((PublisherServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.topicPath().location().extractRegion(), (ClientSettings.Builder)PublisherServiceSettings.newBuilder())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized PartitionPublisherFactory getPartitionPublisherFactory() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        final PublisherServiceClient client = this.newServiceClient();
        return new PartitionPublisherFactory(){

            public @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized MessageMetadata> newPublisher(@UnknownKeyFor @NonNull @Initialized Partition partition) throws @UnknownKeyFor @NonNull @Initialized ApiException {
                SinglePartitionPublisherBuilder.Builder singlePartitionBuilder = SinglePartitionPublisherBuilder.newBuilder().setTopic(PublisherAssembler.this.options.topicPath()).setPartition(partition).setBatchingSettings(PublisherSettings.DEFAULT_BATCHING_SETTINGS).setStreamFactory(responseStream -> {
                    GrpcCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((TopicPath)PublisherAssembler.this.options.topicPath(), (Partition)partition));
                    return client.publishCallable().splitCall(responseStream, (ApiCallContext)context);
                });
                return singlePartitionBuilder.build();
            }

            public void close() {
                client.close();
            }
        };
    }

    @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized MessageMetadata> newPublisher() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        return PartitionCountWatchingPublisherSettings.newBuilder().setTopic(this.options.topicPath()).setPublisherFactory(this.getPartitionPublisherFactory()).setAdminClient(this.newAdminClient()).build().instantiate();
    }
}

