/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Bytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ByteKeyRangeTracker
extends RestrictionTracker<ByteKeyRange, ByteKey>
implements RestrictionTracker.HasProgress {
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized ByteKeyRange NO_KEYS = ByteKeyRange.of(ByteKey.EMPTY, ByteKey.of(0));
    private @UnknownKeyFor @NonNull @Initialized ByteKeyRange range;
    private @Nullable @UnknownKeyFor @Initialized ByteKey lastClaimedKey = null;
    private @Nullable @UnknownKeyFor @Initialized ByteKey lastAttemptedKey = null;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] ZERO_BYTE_ARRAY = new byte[]{0};

    private ByteKeyRangeTracker(@UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
        this.range = (ByteKeyRange)Preconditions.checkNotNull((Object)range);
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteKeyRangeTracker of(@UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
        return new ByteKeyRangeTracker(ByteKeyRange.of(range.getStartKey(), range.getEndKey()));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ByteKeyRange currentRestriction() {
        return this.range;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        ByteKey splitPos;
        if (NO_KEYS.equals(this.range) || !this.range.getEndKey().isEmpty() && this.range.getStartKey().equals(this.range.getEndKey())) {
            return null;
        }
        if (this.lastAttemptedKey != null && this.lastAttemptedKey.isEmpty()) {
            return null;
        }
        ByteKey unprocessedRangeStartKey = this.lastAttemptedKey == null ? this.range.getStartKey() : ByteKeyRangeTracker.next(this.lastAttemptedKey);
        ByteKey endKey = this.range.getEndKey();
        if (!endKey.isEmpty() && unprocessedRangeStartKey.compareTo(endKey) >= 0) {
            return null;
        }
        if (fractionOfRemainder == 0.0) {
            if (this.lastAttemptedKey == null) {
                ByteKeyRange rval = this.range;
                this.range = this.range.getStartKey().isEmpty() ? NO_KEYS : ByteKeyRange.of(this.range.getStartKey(), this.range.getStartKey());
                return SplitResult.of(this.range, rval);
            }
            this.range = ByteKeyRange.of(this.range.getStartKey(), unprocessedRangeStartKey);
            return SplitResult.of(this.range, ByteKeyRange.of(unprocessedRangeStartKey, endKey));
        }
        ByteKeyRange unprocessedRange = ByteKeyRange.of(unprocessedRangeStartKey, this.range.getEndKey());
        try {
            splitPos = unprocessedRange.interpolateKey(fractionOfRemainder);
            Preconditions.checkState((!splitPos.isEmpty() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            return null;
        }
        if (!this.range.getEndKey().isEmpty() && splitPos.compareTo(this.range.getEndKey()) >= 0) {
            return null;
        }
        this.range = ByteKeyRange.of(this.range.getStartKey(), splitPos);
        return SplitResult.of(this.range, ByteKeyRange.of(splitPos, endKey));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized ByteKey key) {
        if (key.isEmpty()) {
            Preconditions.checkArgument((this.lastAttemptedKey == null || !this.lastAttemptedKey.isEmpty() ? 1 : 0) != 0, (String)"Trying to claim key %s while last attempted key was %s", (Object)key, (Object)this.lastAttemptedKey);
            this.lastAttemptedKey = key;
            return false;
        }
        Preconditions.checkArgument((this.lastAttemptedKey == null || key.compareTo(this.lastAttemptedKey) > 0 ? 1 : 0) != 0, (String)"Trying to claim key %s while last attempted key was %s", (Object)key, (Object)this.lastAttemptedKey);
        Preconditions.checkArgument((key.compareTo(this.range.getStartKey()) >= 0 ? 1 : 0) != 0, (String)"Trying to claim key %s before start of the range %s", (Object)key, (Object)this.range);
        this.lastAttemptedKey = key;
        if (!this.range.getEndKey().isEmpty() && key.compareTo(this.range.getEndKey()) >= 0) {
            return false;
        }
        this.lastClaimedKey = key;
        return true;
    }

    @Override
    public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (NO_KEYS.equals(this.range) || !this.range.getEndKey().isEmpty() && this.range.getStartKey().equals(this.range.getEndKey())) {
            return;
        }
        Preconditions.checkState((this.lastAttemptedKey != null ? 1 : 0) != 0, (String)"Key range is non-empty %s and no keys have been attempted.", (Object)this.range);
        if (this.lastAttemptedKey.isEmpty()) {
            return;
        }
        if (!this.range.getEndKey().isEmpty() && ByteKeyRangeTracker.next(this.lastAttemptedKey).compareTo(this.range.getEndKey()) >= 0) {
            return;
        }
        if (this.range.getEndKey().isEmpty() || this.range.getEndKey().compareTo(this.lastAttemptedKey) > 0) {
            ByteKey nextKey = ByteKeyRangeTracker.next(this.lastAttemptedKey);
            throw new IllegalStateException(String.format("Last attempted key was %s in range %s, claiming work in [%s, %s) was not attempted", this.lastAttemptedKey, this.range, nextKey, this.range.getEndKey()));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.BOUNDED;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)this.range).add("lastClaimedKey", (Object)this.lastClaimedKey).add("lastAttemptedKey", (Object)this.lastAttemptedKey).toString();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized ByteKey next(@UnknownKeyFor @NonNull @Initialized ByteKey key) {
        return ByteKey.copyFrom(Bytes.concat((byte[][])new byte[][]{key.getBytes(), ZERO_BYTE_ARRAY}));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
        if (NO_KEYS.equals(this.range)) {
            return RestrictionTracker.Progress.from(0.0, 0.0);
        }
        if (this.lastAttemptedKey == null) {
            return RestrictionTracker.Progress.from(0.0, 1.0);
        }
        if (this.lastAttemptedKey.isEmpty() || !this.range.getEndKey().isEmpty() && this.range.getEndKey().compareTo(this.lastAttemptedKey) <= 0) {
            return RestrictionTracker.Progress.from(1.0, 0.0);
        }
        double workCompleted = this.range.estimateFractionForKey(this.lastAttemptedKey);
        return RestrictionTracker.Progress.from(workCompleted, 1.0 - workCompleted);
    }
}

