/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.wire.HashWire;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.utils.JavaSourceCodeFormatter;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;
import net.openhft.compiler.CachedCompiler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractClassGenerator<MD extends MetaData<MD>> {
    public static final CachedCompiler CACHED_COMPILER = new CachedCompiler(Jvm.isDebug() ? new File(OS.getTarget(), "generated-test-sources") : null, null);
    private static final boolean DUMP_CODE = Jvm.getBoolean((String)"dumpCode");
    protected final SourceCodeFormatter sourceCode = new JavaSourceCodeFormatter();
    protected SortedSet<String> importSet = new TreeSet<String>();
    private final MD metaData;
    private int maxCode = 6;

    protected AbstractClassGenerator(MD metaData) {
        this.metaData = metaData;
    }

    public MD metaData() {
        return this.metaData;
    }

    public synchronized Class acquireClass(ClassLoader classLoader) {
        String fullName = ((MetaData)this.metaData).packageName() + "." + this.className();
        try {
            return classLoader.loadClass(fullName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (this.sourceCode.length() == 0) {
                    JavaSourceCodeFormatter mainCode = new JavaSourceCodeFormatter();
                    this.generateMainCode(mainCode);
                    this.sourceCode.append("package " + ((MetaData)this.metaData).packageName() + ";\n\n");
                    String extendsClassName = this.nameForClass(this.extendsClass());
                    String implementsSet = ((MetaData)this.metaData).interfaces().stream().map(this::nameForClass).sorted().collect(Collectors.joining(", "));
                    for (String import0 : this.importSet) {
                        this.sourceCode.append("import " + import0 + ";\n");
                    }
                    this.importSet = Collections.unmodifiableSortedSet(this.importSet);
                    this.sourceCode.append("\n");
                    this.withLineNumber(this.sourceCode).append("public class ").append(this.className());
                    String genericType = this.generateGenericType();
                    if (genericType != null && !genericType.isEmpty()) {
                        this.sourceCode.append('<').append(genericType).append('>');
                    }
                    if (this.extendsClass() != Object.class) {
                        this.sourceCode.append(" extends ").append(extendsClassName);
                    }
                    if (implementsSet.length() > 0) {
                        this.sourceCode.append(" implements ").append(implementsSet);
                    }
                    this.sourceCode.append(" {\n").append(mainCode).append("}\n");
                    if (DUMP_CODE) {
                        System.out.println(this.sourceCode);
                    }
                }
                return CACHED_COMPILER.loadFromJava(classLoader, fullName, this.sourceCode.toString());
            }
            catch (Throwable e) {
                throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + this.sourceCode, e));
            }
        }
    }

    protected String generateGenericType() {
        return null;
    }

    protected Class extendsClass() {
        return Object.class;
    }

    public String nameForClass(Class clazz) {
        if (clazz.isArray()) {
            return this.nameForClass(clazz.getComponentType()) + "[]";
        }
        String s = clazz.getName().replace('$', '.');
        Package aPackage = clazz.getPackage();
        if (aPackage != null && !clazz.getName().contains("$")) {
            if (!"java.lang".equals(aPackage.getName()) && !this.importSet.contains(aPackage.getName() + ".*")) {
                try {
                    if (!this.importSet.contains(s)) {
                        this.importSet.add(s);
                    }
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), "Can't add an import for " + s);
                    throw e;
                }
            }
            return clazz.getSimpleName();
        }
        return s;
    }

    public int maxCode() {
        return this.maxCode;
    }

    public AbstractClassGenerator maxCode(int maxCode) {
        this.maxCode = maxCode;
        return this;
    }

    @NotNull
    protected String className() {
        if (this.maxCode() == 0) {
            return ((MetaData)this.metaData).baseClassName();
        }
        long h = HashWire.hash64(this.metaData);
        String code = Long.toUnsignedString(h, 36);
        if (code.length() > this.maxCode()) {
            code = code.substring(1, this.maxCode());
        }
        char ch = 'A';
        ch = (char)((long)ch + (h >>> 1) % 26L);
        return ((MetaData)this.metaData).baseClassName() + '$' + ch + code;
    }

    protected void generateMainCode(SourceCodeFormatter mainCode) {
        if (((MetaData)this.metaData).useUpdateInterceptor()) {
            mainCode.append("private transient final " + this.nameForClass(UpdateInterceptor.class) + " updateInterceptor;\n");
        }
        this.generateFields(mainCode);
        mainCode.append('\n');
        this.generateConstructors(mainCode);
        this.generateMethods(mainCode);
        this.generateEnd(mainCode);
    }

    protected String fieldCase(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "flag";
            }
            return clazz.getName().substring(0, 1);
        }
        String simpleName = clazz.getSimpleName();
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }

    protected void generateFields(SourceCodeFormatter mainCode) {
    }

    protected void generateConstructors(SourceCodeFormatter mainCode) {
    }

    protected SourceCodeFormatter withLineNumber(SourceCodeFormatter mainCode) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        mainCode.append("//").append("\tat ").append(stackTrace[2].toString()).append("\n");
        return mainCode;
    }

    private void generateMethods(SourceCodeFormatter mainCode) {
        for (Method m : this.methodsToOverride()) {
            this.generateMethod(m, mainCode);
        }
    }

    protected void generateMethod(Method method, SourceCodeFormatter mainCode) {
        String name = method.getName();
        this.withLineNumber(mainCode).append("public ").append(this.nameForClass(method.getReturnType())).append(" ").append(name).append("(");
        Class<?>[] pts = method.getParameterTypes();
        String sep = "";
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuilder params = new StringBuilder();
        Parameter[] parameters = method.getParameters();
        int ptsLength = pts.length;
        for (int i = 0; i < ptsLength; ++i) {
            Class<?> pt = pts[i];
            mainCode.append(sep);
            params.append(sep);
            sep = ", ";
            String pname = parameters[i].getName();
            if (paramList.contains(pname)) {
                pname = pname + paramList.size();
            }
            paramList.add(pname);
            params.append(pname);
            mainCode.append(this.nameForClass(pt)).append(' ').append(pname);
        }
        mainCode.append(") {\n");
        if (((MetaData)this.metaData).useUpdateInterceptor()) {
            this.withLineNumber(mainCode).append("// updateInterceptor\n").append("if (!this.updateInterceptor.update(\"").append(name).append("\", ").append((CharSequence)paramList.get(0)).append(")) {\n").append("return").append(this.returnDefault(method.getReturnType())).append(";\n").append("}\n");
        }
        this.generateMethod(method, params, paramList, mainCode);
        mainCode.append("}\n");
    }

    protected void generateEnd(SourceCodeFormatter mainCode) {
    }

    private String returnDefault(Class<?> returnType) {
        if (returnType == Void.TYPE) {
            return "";
        }
        if (returnType.isPrimitive()) {
            throw new UnsupportedOperationException("having a method of this return type=" + returnType + " is not supported by method writers");
        }
        if (returnType.isInterface()) {
            return " this";
        }
        return " null";
    }

    protected abstract void generateMethod(Method var1, StringBuilder var2, List<String> var3, SourceCodeFormatter var4);

    @NotNull
    protected Set<Method> methodsToOverride() {
        TreeMap<String, Method> sig2methodMap = new TreeMap<String, Method>();
        LinkedHashSet<String> overridenSet = new LinkedHashSet<String>();
        for (Class clazz : ((MetaData)this.metaData()).interfaces()) {
            this.addMethodsFor(sig2methodMap, overridenSet, clazz);
        }
        this.addMethodsFor(sig2methodMap, overridenSet, this.extendsClass());
        for (String sig : overridenSet) {
            sig2methodMap.remove(sig);
        }
        return new LinkedHashSet<Method>(sig2methodMap.values());
    }

    private void addMethodsFor(Map<String, Method> sig2methodMap, Set<String> overridenSet, Class clazz) {
        for (Method method : clazz.getMethods()) {
            String sig = method.getName() + Arrays.toString(method.getParameterTypes());
            if (Modifier.isAbstract(method.getModifiers())) {
                sig2methodMap.putIfAbsent(sig, method);
                continue;
            }
            overridenSet.add(sig);
        }
    }

    public static abstract class MetaData<MD extends MetaData<MD>>
    extends SelfDescribingMarshallable {
        private String packageName = "";
        private String baseClassName = "";
        private Set<Class> interfaces = new LinkedHashSet<Class>();
        private boolean useUpdateInterceptor;

        public String packageName() {
            return this.packageName;
        }

        public MD packageName(String packageName) {
            this.packageName = packageName;
            return (MD)this;
        }

        public String baseClassName() {
            return this.baseClassName;
        }

        public MD baseClassName(String baseClassName) {
            this.baseClassName = baseClassName;
            return (MD)this;
        }

        public Set<Class> interfaces() {
            return this.interfaces;
        }

        public MD interfaces(Set<Class> interfaces) {
            this.interfaces = interfaces;
            return (MD)this;
        }

        public boolean useUpdateInterceptor() {
            return this.useUpdateInterceptor;
        }

        public MD useUpdateInterceptor(boolean useUpdateInterceptor) {
            this.useUpdateInterceptor = useUpdateInterceptor;
            return (MD)this;
        }
    }
}

