/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.copy;

public class CopyContext {
    private final boolean preserveChangedState;
    private final boolean deepCopy;
    private final boolean preserveParentReferences;
    private final boolean copyErrorHandling;
    private final boolean copyPartitioning;
    private final boolean copyAttributes;
    public static final CopyContext DEFAULT = new Builder().preserveChangedState(true).deepCopy(true).preserveParentReferences(false).copyErrorHandling(true).copyPartitioning(true).copyAttributes(true).build();
    public static final CopyContext LIGHTWEIGHT = new Builder().preserveChangedState(false).deepCopy(false).preserveParentReferences(false).copyErrorHandling(false).copyPartitioning(false).copyAttributes(false).build();
    public static final CopyContext SAME_PIPELINE = new Builder().preserveChangedState(true).deepCopy(true).preserveParentReferences(true).copyErrorHandling(true).copyPartitioning(true).copyAttributes(true).build();

    private CopyContext(Builder builder) {
        this.preserveChangedState = builder.preserveChangedState;
        this.deepCopy = builder.deepCopy;
        this.preserveParentReferences = builder.preserveParentReferences;
        this.copyErrorHandling = builder.copyErrorHandling;
        this.copyPartitioning = builder.copyPartitioning;
        this.copyAttributes = builder.copyAttributes;
    }

    public boolean isPreserveChangedState() {
        return this.preserveChangedState;
    }

    public boolean isDeepCopy() {
        return this.deepCopy;
    }

    public boolean isPreserveParentReferences() {
        return this.preserveParentReferences;
    }

    public boolean isCopyErrorHandling() {
        return this.copyErrorHandling;
    }

    public boolean isCopyPartitioning() {
        return this.copyPartitioning;
    }

    public boolean isCopyAttributes() {
        return this.copyAttributes;
    }

    public String toString() {
        return "CopyContext{preserveChangedState=" + this.preserveChangedState + ", deepCopy=" + this.deepCopy + ", preserveParentReferences=" + this.preserveParentReferences + ", copyErrorHandling=" + this.copyErrorHandling + ", copyPartitioning=" + this.copyPartitioning + ", copyAttributes=" + this.copyAttributes + "}";
    }

    public static class Builder {
        private boolean preserveChangedState = true;
        private boolean deepCopy = true;
        private boolean preserveParentReferences = false;
        private boolean copyErrorHandling = true;
        private boolean copyPartitioning = true;
        private boolean copyAttributes = true;

        public Builder preserveChangedState(boolean preserveChangedState) {
            this.preserveChangedState = preserveChangedState;
            return this;
        }

        public Builder deepCopy(boolean deepCopy) {
            this.deepCopy = deepCopy;
            return this;
        }

        public Builder preserveParentReferences(boolean preserveParentReferences) {
            this.preserveParentReferences = preserveParentReferences;
            return this;
        }

        public Builder copyErrorHandling(boolean copyErrorHandling) {
            this.copyErrorHandling = copyErrorHandling;
            return this;
        }

        public Builder copyPartitioning(boolean copyPartitioning) {
            this.copyPartitioning = copyPartitioning;
            return this;
        }

        public Builder copyAttributes(boolean copyAttributes) {
            this.copyAttributes = copyAttributes;
            return this;
        }

        public CopyContext build() {
            return new CopyContext(this);
        }
    }
}

