/*
 * Decompiled with CFR 0.152.
 */
package com.charleskorn.kaml;

import com.charleskorn.kaml.Location;
import com.charleskorn.kaml.YamlNode;
import com.charleskorn.kaml.YamlScalar;
import com.charleskorn.kaml.YamlScalarFormatException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\b\u0010\r\u001a\u00020\u0003H\u0016J5\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001H\u0016J\t\u0010\u001b\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Lcom/charleskorn/kaml/YamlScalar;", "Lcom/charleskorn/kaml/YamlNode;", "content", "", "location", "Lcom/charleskorn/kaml/Location;", "(Ljava/lang/String;Lcom/charleskorn/kaml/Location;)V", "getContent", "()Ljava/lang/String;", "getLocation", "()Lcom/charleskorn/kaml/Location;", "component1", "component2", "contentToString", "convertToIntegerLikeValue", "T", "converter", "Lkotlin/Function2;", "", "description", "(Lkotlin/jvm/functions/Function2;Ljava/lang/String;)Ljava/lang/Object;", "copy", "equals", "", "other", "", "equivalentContentTo", "hashCode", "toBoolean", "toByte", "", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toLong", "", "toShort", "", "toString", "kaml"})
public final class YamlScalar
extends YamlNode {
    @NotNull
    private final String content;
    @NotNull
    private final Location location;

    @Override
    public boolean equivalentContentTo(@NotNull YamlNode other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof YamlScalar && Intrinsics.areEqual((Object)this.content, (Object)((YamlScalar)other).content);
    }

    @Override
    @NotNull
    public String contentToString() {
        return '\'' + this.content + '\'';
    }

    public final byte toByte() {
        return ((Number)this.convertToIntegerLikeValue(toByte.1.INSTANCE, "byte")).byteValue();
    }

    public final short toShort() {
        return ((Number)this.convertToIntegerLikeValue(toShort.1.INSTANCE, "short")).shortValue();
    }

    public final int toInt() {
        return ((Number)this.convertToIntegerLikeValue(toInt.1.INSTANCE, "integer")).intValue();
    }

    public final long toLong() {
        return ((Number)this.convertToIntegerLikeValue(toLong.1.INSTANCE, "long")).longValue();
    }

    private final <T> T convertToIntegerLikeValue(Function2<? super String, ? super Integer, ? extends T> converter, String description) {
        try {
            Object object;
            if (StringsKt.startsWith$default((String)this.content, (String)"0x", (boolean)false, (int)2, null)) {
                String string = this.content;
                int n = 2;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                object = converter.invoke((Object)string3, (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0x", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("-");
                String string = this.content;
                int n = 3;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                object = converter.invoke((Object)stringBuilder.append(string5).toString(), (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"0o", (boolean)false, (int)2, null)) {
                String string = this.content;
                int n = 2;
                boolean bl = false;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                object = converter.invoke((Object)string7, (Object)8);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0o", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("-");
                String string = this.content;
                int n = 3;
                boolean bl = false;
                String string8 = string;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                object = converter.invoke((Object)stringBuilder.append(string9).toString(), (Object)8);
            } else {
                object = converter.invoke((Object)this.content, (Object)10);
            }
            return (T)object;
        }
        catch (NumberFormatException e) {
            throw (Throwable)new YamlScalarFormatException("Value '" + this.content + "' is not a valid " + description + " value.", this.getLocation(), this.content);
        }
    }

    public final float toFloat() {
        float f;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                f = Float.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                f = Float.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                f = Float.NaN;
                break;
            }
            default: {
                float f2;
                try {
                    String string = this.content;
                    boolean bl = false;
                    f2 = Float.parseFloat(string);
                }
                catch (NumberFormatException e) {
                    throw (Throwable)new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getLocation(), this.content);
                }
                f = f2;
            }
        }
        return f;
    }

    public final double toDouble() {
        double d;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                d = Double.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                d = Double.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                d = Double.NaN;
                break;
            }
            default: {
                double d2;
                try {
                    String string = this.content;
                    boolean bl = false;
                    d2 = Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    throw (Throwable)new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", this.getLocation(), this.content);
                }
                d = d2;
            }
        }
        return d;
    }

    public final boolean toBoolean() {
        boolean bl;
        switch (this.content) {
            case "true": 
            case "True": 
            case "TRUE": {
                bl = true;
                break;
            }
            case "false": 
            case "FALSE": 
            case "False": {
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new YamlScalarFormatException("Value '" + this.content + "' is not a valid boolean, permitted choices are: true or false", this.getLocation(), this.content);
            }
        }
        return bl;
    }

    public final char toChar() {
        Character c = StringsKt.singleOrNull((CharSequence)this.content);
        if (c == null) {
            throw (Throwable)new YamlScalarFormatException("Value '" + this.content + "' is not a valid character value.", this.getLocation(), this.content);
        }
        return c.charValue();
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public YamlScalar(@NotNull String content, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location, null);
        this.content = content;
        this.location = location;
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final Location component2() {
        return this.getLocation();
    }

    @NotNull
    public final YamlScalar copy(@NotNull String content, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new YamlScalar(content, location);
    }

    public static /* synthetic */ YamlScalar copy$default(YamlScalar yamlScalar, String string, Location location, int n, Object object) {
        if ((n & 1) != 0) {
            string = yamlScalar.content;
        }
        if ((n & 2) != 0) {
            location = yamlScalar.getLocation();
        }
        return yamlScalar.copy(string, location);
    }

    @NotNull
    public String toString() {
        return "YamlScalar(content=" + this.content + ", location=" + this.getLocation() + ")";
    }

    public int hashCode() {
        String string = this.content;
        Location location = this.getLocation();
        return (string != null ? string.hashCode() : 0) * 31 + (location != null ? ((Object)location).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof YamlScalar)) break block3;
                YamlScalar yamlScalar = (YamlScalar)object;
                if (!Intrinsics.areEqual((Object)this.content, (Object)yamlScalar.content) || !Intrinsics.areEqual((Object)this.getLocation(), (Object)yamlScalar.getLocation())) break block3;
            }
            return true;
        }
        return false;
    }
}

