/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.operator.config;

import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class OperatorOptions
extends OptionHolder {
    private static volatile OperatorOptions INSTANCE;
    public static final ConfigOption<String> WATCH_NAMESPACE;
    public static final ConfigOption<String> TIMEZONE;
    public static final ConfigOption<Integer> PROBE_PORT;
    public static final ConfigOption<Integer> PROBE_BACKLOG;
    public static final ConfigOption<Long> RESYNC_PERIOD;
    public static final ConfigOption<Integer> RECONCILER_COUNT;
    public static final ConfigOption<Long> CLOSE_RECONCILER_TIMEOUT;
    public static final ConfigOption<Long> READY_CHECK_INTERNAL;
    public static final ConfigOption<Long> READY_TIMEOUT;
    public static final ConfigOption<Integer> MAX_RECONCILE_RETRY;
    public static final ConfigOption<String> INTERNAL_ETCD_URL;
    public static final ConfigOption<Boolean> AUTO_DESTROY_POD;

    private OperatorOptions() {
    }

    public static synchronized OperatorOptions instance() {
        if (INSTANCE == null) {
            INSTANCE = new OperatorOptions();
            INSTANCE.registerOptions();
        }
        return INSTANCE;
    }

    static {
        WATCH_NAMESPACE = new ConfigOption<String>("k8s.watch_namespace", "The value is watch custom resources in the namespace, ignore other namespaces, the '*' means is all namespaces will be watched.", OptionChecker.disallowEmpty(), "hugegraph-computer-system");
        TIMEZONE = new ConfigOption<String>("k8s.timezone", "The timezone of computer job and operator.", OptionChecker.disallowEmpty(), "Asia/Shanghai");
        PROBE_PORT = new ConfigOption<Integer>("k8s.probe_port", "The value is the port that the controller bind to for serving health probes.", OptionChecker.positiveInt(), 9892);
        PROBE_BACKLOG = new ConfigOption<Integer>("k8s.probe_backlog", "The maximum backlog for serving health probes.", OptionChecker.positiveInt(), 50);
        RESYNC_PERIOD = new ConfigOption<Long>("k8s.resync_period", "The minimum frequency at which watched resources are reconciled.", OptionChecker.positiveInt(), 600000L);
        RECONCILER_COUNT = new ConfigOption<Integer>("k8s.reconciler_count", "The max number of reconciler thread.", OptionChecker.positiveInt(), Runtime.getRuntime().availableProcessors());
        CLOSE_RECONCILER_TIMEOUT = new ConfigOption<Long>("k8s.close_reconciler_timeout", "The max timeout(in ms) to close reconciler.", OptionChecker.positiveInt(), 120L);
        READY_CHECK_INTERNAL = new ConfigOption<Long>("k8s.ready_check_internal", "The time interval(ms) of check ready.", OptionChecker.positiveInt(), 1000L);
        READY_TIMEOUT = new ConfigOption<Long>("k8s.ready_timeout", "The max timeout(in ms) of check ready.", OptionChecker.positiveInt(), 30000L);
        MAX_RECONCILE_RETRY = new ConfigOption<Integer>("k8s.max_reconcile_retry", "The max retry times of reconcile.", OptionChecker.positiveInt(), 3);
        INTERNAL_ETCD_URL = new ConfigOption<String>("k8s.internal_etcd_url", "The internal etcd url for operator system.", OptionChecker.disallowEmpty(), "http://127.0.0.1:2379");
        AUTO_DESTROY_POD = new ConfigOption<Boolean>("k8s.auto_destroy_pod", "Whether to automatically destroy all pods when the job is completed or failed.", OptionChecker.allowValues(true, false), true);
    }
}

