/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.id;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hugegraph.computer.core.common.SerialEnum;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.id.IdType;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.util.BytesUtil;
import org.apache.hugegraph.computer.core.util.CoderUtil;
import org.apache.hugegraph.util.E;

public class BytesId
implements Id {
    public static final BytesId EMPTY = BytesId.of("");
    private IdType idType;
    private byte[] bytes;
    private int length;

    public BytesId() {
        this.idType = BytesId.EMPTY.idType;
        this.bytes = BytesId.EMPTY.bytes;
        this.length = BytesId.EMPTY.length;
    }

    public BytesId(IdType idType, byte[] bytes) {
        this(idType, bytes, bytes.length);
    }

    public BytesId(IdType idType, byte[] bytes, long length) {
        E.checkArgument((bytes != null ? 1 : 0) != 0, (String)"The bytes can't be null", (Object[])new Object[0]);
        this.idType = idType;
        this.bytes = bytes;
        this.length = (int)length;
    }

    public static BytesId of(long value) {
        BytesOutput output = IOFactory.createBytesOutput(9);
        try {
            output.writeLong(value);
        }
        catch (IOException e) {
            throw new ComputerException("Failed to write Long object to BytesId");
        }
        return new BytesId(IdType.LONG, output.buffer(), output.position());
    }

    public static BytesId of(String value) {
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"The value can't be null", (Object[])new Object[0]);
        return new BytesId(IdType.UTF8, CoderUtil.encode((String)value));
    }

    public static BytesId of(UUID value) {
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"The value can't be null", (Object[])new Object[0]);
        long high = value.getMostSignificantBits();
        long low = value.getLeastSignificantBits();
        BytesOutput output = IOFactory.createBytesOutput(16);
        try {
            output.writeLong(high);
            output.writeLong(low);
        }
        catch (IOException e) {
            throw new ComputerException("Failed to write UUID object to BytesId");
        }
        return new BytesId(IdType.UUID, output.buffer(), output.position());
    }

    public ValueType valueType() {
        return ValueType.ID;
    }

    public IdType idType() {
        return this.idType;
    }

    public void assign(Value other) {
        this.checkAssign(other);
        this.idType = ((BytesId)other).idType;
        this.bytes = ((BytesId)other).bytes;
        this.length = ((BytesId)other).length;
    }

    public Id copy() {
        byte[] copyBytes = Arrays.copyOf(this.bytes, this.length);
        return new BytesId(this.idType, copyBytes, this.length);
    }

    public int length() {
        return this.length;
    }

    public Object value() {
        return this.asObject();
    }

    public Object asObject() {
        switch (this.idType) {
            case LONG: {
                BytesInput input = IOFactory.createBytesInput(this.bytes, 0, this.length);
                try {
                    return input.readLong();
                }
                catch (IOException e) {
                    throw new ComputerException("Failed to read BytesId to Long object");
                }
            }
            case UTF8: {
                return CoderUtil.decode((byte[])this.bytes, (int)0, (int)this.length);
            }
            case UUID: {
                BytesInput input = IOFactory.createBytesInput(this.bytes, 0, this.length);
                try {
                    long high = input.readLong();
                    long low = input.readLong();
                    return new UUID(high, low);
                }
                catch (IOException e) {
                    throw new ComputerException("Failed to read BytesId to UUID object");
                }
            }
        }
        throw new ComputerException("Unexpected IdType %s", new Object[]{this.idType});
    }

    public void read(RandomAccessInput in) throws IOException {
        assert (this != EMPTY) : "can't read to EMPTY id";
        this.idType = (IdType)SerialEnum.fromCode(IdType.class, (byte)in.readByte());
        int len = in.readInt();
        this.bytes = BytesUtil.ensureCapacityWithoutCopy((byte[])this.bytes, (int)len);
        in.readFully(this.bytes, 0, len);
        this.length = len;
    }

    public void write(RandomAccessOutput out) throws IOException {
        out.writeByte((int)this.idType.code());
        out.writeInt(this.length);
        out.write(this.bytes, 0, this.length);
    }

    public int compareTo(Value obj) {
        int typeDiff = this.valueType().compareTo((Enum)obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        typeDiff = this.idType().code() - ((Id)obj).idType().code();
        if (typeDiff != 0) {
            return typeDiff;
        }
        BytesId other = (BytesId)obj;
        return BytesUtil.compare((byte[])this.bytes, (int)this.length, (byte[])other.bytes, (int)other.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BytesId)) {
            return false;
        }
        BytesId other = (BytesId)obj;
        if (this.idType != other.idType) {
            return false;
        }
        return BytesUtil.compare((byte[])this.bytes, (int)this.length, (byte[])other.bytes, (int)other.length) == 0;
    }

    public int hashCode() {
        return BytesUtil.hashBytes((byte[])this.bytes, (int)this.length);
    }

    public String toString() {
        return this.asObject().toString();
    }
}

