/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.manager;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class Managers
implements Iterable<Manager> {
    private final Map<String, Manager> managers = InsertionOrderUtil.newMap();

    public <T extends Manager> T get(String name) {
        Manager manager = this.managers.get(name);
        E.checkArgumentNotNull((Object)manager, (String)"Not found manager '%s'", (Object[])new Object[]{name});
        Manager subManager = manager;
        return (T)subManager;
    }

    public void add(Manager manager) {
        this.managers.put(manager.name(), manager);
    }

    public Collection<Manager> all() {
        return this.managers.values();
    }

    @Override
    public Iterator<Manager> iterator() {
        return this.managers.values().iterator();
    }

    public void initAll(Config config) {
        for (Manager manager : this.all()) {
            manager.init(config);
        }
    }

    public void initedAll(Config config) {
        for (Manager manager : this.all()) {
            manager.inited(config);
        }
    }

    public void closeAll(Config config) {
        for (Manager manager : this.all()) {
            manager.close(config);
        }
    }

    public void beforeSuperstep(Config config, int superstep) {
        for (Manager manager : this.all()) {
            manager.beforeSuperstep(config, superstep);
        }
    }

    public void afterSuperstep(Config config, int superstep) {
        for (Manager manager : this.all()) {
            manager.afterSuperstep(config, superstep);
        }
    }
}

