/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network;

import io.netty.channel.epoll.Epoll;
import java.net.InetAddress;
import java.util.Locale;
import org.apache.hugegraph.computer.core.common.exception.IllegalArgException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.network.IOMode;
import org.apache.hugegraph.computer.core.network.TransportProvider;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class TransportConf {
    public static final String SERVER_THREAD_GROUP_NAME = "transport-netty-server";
    public static final String CLIENT_THREAD_GROUP_NAME = "transport-netty-client";
    private final Config config;

    public static TransportConf wrapConfig(Config config) {
        return new TransportConf(config);
    }

    protected TransportConf(Config config) {
        this.config = config;
    }

    public InetAddress serverAddress() {
        String host = (String)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SERVER_HOST);
        return TransportUtil.resolvedAddress(host);
    }

    public int serverPort() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SERVER_PORT);
    }

    public int serverThreads() {
        return Math.min((Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SERVER_THREADS), this.maxTransportThreads());
    }

    public int clientThreads() {
        return Math.min((Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_CLIENT_THREADS), this.maxTransportThreads());
    }

    private int maxTransportThreads() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.JOB_WORKERS_COUNT);
    }

    public TransportProvider transportProvider() {
        return (TransportProvider)this.config.createObject(ComputerOptions.TRANSPORT_PROVIDER_CLASS);
    }

    public boolean recvBufferFileMode() {
        return (Boolean)this.config.get((TypedOption)ComputerOptions.TRANSPORT_RECV_FILE_MODE);
    }

    public IOMode ioMode() {
        String ioMode;
        switch (ioMode = ((String)this.config.get((TypedOption)ComputerOptions.TRANSPORT_IO_MODE)).toUpperCase(Locale.ROOT)) {
            case "NIO": {
                return IOMode.NIO;
            }
            case "EPOLL": {
                return IOMode.EPOLL;
            }
            case "AUTO": {
                return Epoll.isAvailable() ? IOMode.EPOLL : IOMode.NIO;
            }
        }
        throw new IllegalArgException("Unknown io_mode: %s", ioMode);
    }

    public boolean epollLevelTriggered() {
        return (Boolean)this.config.get((TypedOption)ComputerOptions.TRANSPORT_EPOLL_LT);
    }

    public boolean tcpKeepAlive() {
        return (Boolean)this.config.get((TypedOption)ComputerOptions.TRANSPORT_TCP_KEEP_ALIVE);
    }

    public int maxSynBacklog() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_MAX_SYN_BACKLOG);
    }

    public int sizeReceiveBuffer() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_RECEIVE_BUFFER_SIZE);
    }

    public int sizeSendBuffer() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SEND_BUFFER_SIZE);
    }

    public int networkRetries() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_NETWORK_RETRIES);
    }

    public long clientConnectionTimeout() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_CLIENT_CONNECT_TIMEOUT);
    }

    public long closeTimeout() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_CLOSE_TIMEOUT);
    }

    public long timeoutSyncRequest() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SYNC_REQUEST_TIMEOUT);
    }

    public long timeoutFinishSession() {
        long timeout = (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_FINISH_SESSION_TIMEOUT);
        return timeout > 0L ? timeout : (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SYNC_REQUEST_TIMEOUT) * (long)((Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_MAX_PENDING_REQUESTS)).intValue();
    }

    public long writeSocketTimeout() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_WRITE_SOCKET_TIMEOUT);
    }

    public int writeBufferHighMark() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_WRITE_BUFFER_HIGH_MARK);
    }

    public int writeBufferLowMark() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_WRITE_BUFFER_LOW_MARK);
    }

    public int maxPendingRequests() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_MAX_PENDING_REQUESTS);
    }

    public int minPendingRequests() {
        int maxPendingRequests;
        int minPendingReqs = (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_MIN_PENDING_REQUESTS);
        E.checkArgument((minPendingReqs <= (maxPendingRequests = this.maxPendingRequests()) ? 1 : 0) != 0, (String)"The min_pending_requests(%s) must be less than or equal to the max_pending_requests(%s).", (Object[])new Object[]{minPendingReqs, maxPendingRequests});
        return minPendingReqs;
    }

    public long minAckInterval() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_MIN_ACK_INTERVAL);
    }

    public long serverIdleTimeout() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_SERVER_IDLE_TIMEOUT);
    }

    public long heartbeatInterval() {
        return (Long)this.config.get((TypedOption)ComputerOptions.TRANSPORT_HEARTBEAT_INTERVAL);
    }

    public int maxTimeoutHeartbeatCount() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.TRANSPORT_MAX_TIMEOUT_HEARTBEAT_COUNT);
    }
}

