/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.network.TransportHandler;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ChannelFutureListenerOnWrite
implements ChannelFutureListener {
    private static final Logger LOG = Log.logger(ChannelFutureListenerOnWrite.class);
    private final TransportHandler handler;

    protected ChannelFutureListenerOnWrite(TransportHandler handler) {
        this.handler = handler;
    }

    public void operationComplete(ChannelFuture future) {
        if (future.isDone()) {
            Channel channel = future.channel();
            this.onDone(channel, future);
        }
    }

    public void onDone(Channel channel, ChannelFuture future) {
        if (future.isSuccess()) {
            this.onSuccess(channel, future);
        } else {
            this.onFailure(channel, future.cause());
        }
    }

    public void onSuccess(Channel channel, ChannelFuture future) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully send data to '{}'", (Object)TransportUtil.remoteAddress(channel));
        }
    }

    public void onFailure(Channel channel, Throwable cause) {
        TransportException exception = cause instanceof TransportException ? (TransportException)cause : new TransportException("Failed to send data to '%s': %s", cause, TransportUtil.remoteAddress(channel), cause.getMessage());
        ConnectionId connectionId = TransportUtil.remoteConnectionId(channel);
        this.handler.exceptionCaught(exception, connectionId);
    }
}

