/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.BitSet;
import org.h2.util.MathUtils;

public class FreeSpaceBitSet {
    private static final boolean DETAILED_INFO = false;
    private final int firstFreeBlock;
    private final int blockSize;
    private final BitSet set = new BitSet();

    public FreeSpaceBitSet(int n, int n2) {
        this.firstFreeBlock = n;
        this.blockSize = n2;
        this.clear();
    }

    public void clear() {
        this.set.clear();
        this.set.set(0, this.firstFreeBlock);
    }

    public boolean isUsed(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        for (int i = n2; i < n2 + n3; ++i) {
            if (this.set.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isFree(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        for (int i = n2; i < n2 + n3; ++i) {
            if (!this.set.get(i)) continue;
            return false;
        }
        return true;
    }

    public long allocate(int n) {
        return this.allocate(n, true);
    }

    public long predictAllocation(int n) {
        return this.allocate(n, false);
    }

    private long allocate(int n, boolean bl) {
        int n2 = this.getBlockCount(n);
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.set.nextSetBit((n4 = this.set.nextClearBit(n3)) + 1)) < 0 || n5 - n4 >= n2) {
                assert (this.set.nextSetBit(n4) == -1 || this.set.nextSetBit(n4) >= n4 + n2) : "Double alloc: " + Integer.toHexString(n4) + "/" + Integer.toHexString(n2) + " " + this;
                if (bl) {
                    this.set.set(n4, n4 + n2);
                }
                return this.getPos(n4);
            }
            n3 = n5;
        }
    }

    public void markUsed(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        assert (this.set.nextSetBit(n2) == -1 || this.set.nextSetBit(n2) >= n2 + n3) : "Double mark: " + Integer.toHexString(n2) + "/" + Integer.toHexString(n3) + " " + this;
        this.set.set(n2, n2 + n3);
    }

    public void free(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        assert (this.set.nextClearBit(n2) >= n2 + n3) : "Double free: " + Integer.toHexString(n2) + "/" + Integer.toHexString(n3) + " " + this;
        this.set.clear(n2, n2 + n3);
    }

    private long getPos(int n) {
        return (long)n * (long)this.blockSize;
    }

    private int getBlock(long l) {
        return (int)(l / (long)this.blockSize);
    }

    private int getBlockCount(int n) {
        return MathUtils.roundUpInt(n, this.blockSize) / this.blockSize;
    }

    public int getFillRate() {
        int n = this.set.cardinality();
        if (n == 0) {
            return 0;
        }
        return Math.max(1, (int)(100L * (long)n / (long)this.set.length()));
    }

    public long getFirstFree() {
        return this.getPos(this.set.nextClearBit(0));
    }

    public long getLastFree() {
        return this.getPos(this.set.previousSetBit(this.set.size() - 1) + 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = 0;
        while (true) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            int n2 = this.set.nextClearBit(n);
            stringBuilder.append(Integer.toHexString(n2)).append('-');
            int n3 = this.set.nextSetBit(n2 + 1);
            if (n3 < 0) break;
            stringBuilder.append(Integer.toHexString(n3 - 1));
            n = n3 + 1;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

