/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import com.couchbase.client.core.message.internal.DiagnosticsReport;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.state.LifecycleState;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.Health;

class CouchbaseHealth {
    private final DiagnosticsReport diagnostics;

    CouchbaseHealth(DiagnosticsReport diagnostics) {
        this.diagnostics = diagnostics;
    }

    void applyTo(Health.Builder builder) {
        builder = this.isCouchbaseUp(this.diagnostics) ? builder.up() : builder.down();
        builder.withDetail("sdk", this.diagnostics.sdk());
        builder.withDetail("endpoints", this.diagnostics.endpoints().stream().map(this::describe).collect(Collectors.toList()));
    }

    private boolean isCouchbaseUp(DiagnosticsReport diagnostics) {
        for (EndpointHealth health : diagnostics.endpoints()) {
            LifecycleState state = health.state();
            if (state == LifecycleState.CONNECTED || state == LifecycleState.IDLE) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> describe(EndpointHealth endpointHealth) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", endpointHealth.id());
        map.put("lastActivity", endpointHealth.lastActivity());
        map.put("local", endpointHealth.local().toString());
        map.put("remote", endpointHealth.remote().toString());
        map.put("state", endpointHealth.state());
        map.put("type", endpointHealth.type());
        return map;
    }
}

