/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Compare;
import com.baomidou.mybatisplus.core.conditions.interfaces.Func;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.interfaces.Nested;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.enums.WrapperKeyword;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.SerializationUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.StringEscape;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class AbstractWrapper<T, R, Children extends AbstractWrapper<T, R, Children>>
extends Wrapper<T>
implements Compare<Children, R>,
Nested<Children, Children>,
Join<Children>,
Func<Children, R> {
    protected final Children typedThis = this;
    protected AtomicInteger paramNameSeq;
    protected Map<String, Object> paramNameValuePairs;
    protected SharedString lastSql;
    protected SharedString sqlComment;
    protected T entity;
    protected MergeSegments expression;
    protected Class<T> entityClass;

    @Override
    public T getEntity() {
        return this.entity;
    }

    public Children setEntity(T entity) {
        this.entity = entity;
        this.initEntityClass();
        return this.typedThis;
    }

    protected void initEntityClass() {
        if (this.entityClass == null && this.entity != null) {
            this.entityClass = this.entity.getClass();
        }
    }

    protected Class<T> getCheckEntityClass() {
        Assert.notNull(this.entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        return this.entityClass;
    }

    @Override
    public <V> Children allEq(boolean condition, Map<R, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (StringUtils.checkValNotNull(v)) {
                    this.eq(k, v);
                } else if (null2IsNull) {
                    this.isNull(k);
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public <V> Children allEq(boolean condition, BiPredicate<R, V> filter, Map<R, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (filter.test(k, v)) {
                    if (StringUtils.checkValNotNull(v)) {
                        this.eq(k, v);
                    } else if (null2IsNull) {
                        this.isNull(k);
                    }
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public Children eq(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.EQ, val);
    }

    @Override
    public Children ne(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.NE, val);
    }

    @Override
    public Children gt(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GT, val);
    }

    @Override
    public Children ge(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GE, val);
    }

    @Override
    public Children lt(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LT, val);
    }

    @Override
    public Children le(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LE, val);
    }

    @Override
    public Children like(boolean condition, R column, Object val) {
        return this.likeValue(condition, column, val, SqlLike.DEFAULT);
    }

    @Override
    public Children notLike(boolean condition, R column, Object val) {
        return (Children)((AbstractWrapper)this.not(condition)).like(condition, (Object)column, val);
    }

    @Override
    public Children likeLeft(boolean condition, R column, Object val) {
        return this.likeValue(condition, column, val, SqlLike.LEFT);
    }

    @Override
    public Children likeRight(boolean condition, R column, Object val) {
        return this.likeValue(condition, column, val, SqlLike.RIGHT);
    }

    @Override
    public Children between(boolean condition, R column, Object val1, Object val2) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.BETWEEN, () -> this.formatSql("{0}", val1), SqlKeyword.AND, () -> this.formatSql("{0}", val2));
    }

    @Override
    public Children notBetween(boolean condition, R column, Object val1, Object val2) {
        return (Children)((AbstractWrapper)this.not(condition)).between(condition, (Object)column, val1, val2);
    }

    @Override
    public Children and(boolean condition, Consumer<Children> consumer) {
        return ((AbstractWrapper)this.and(condition)).addNestedCondition(condition, consumer);
    }

    @Override
    public Children or(boolean condition, Consumer<Children> consumer) {
        return ((AbstractWrapper)this.or(condition)).addNestedCondition(condition, consumer);
    }

    @Override
    public Children nested(boolean condition, Consumer<Children> consumer) {
        return this.addNestedCondition(condition, consumer);
    }

    @Override
    public Children or(boolean condition) {
        return this.doIt(condition, SqlKeyword.OR);
    }

    @Override
    public Children apply(boolean condition, String applySql, Object ... value) {
        return this.doIt(condition, WrapperKeyword.APPLY, () -> this.formatSql(applySql, value));
    }

    @Override
    public Children last(boolean condition, String lastSql) {
        if (condition) {
            this.lastSql.setStringValue(" " + lastSql);
        }
        return this.typedThis;
    }

    @Override
    public Children comment(boolean condition, String comment) {
        if (condition) {
            this.sqlComment.setStringValue(comment);
        }
        return this.typedThis;
    }

    @Override
    public Children exists(boolean condition, String existsSql) {
        return this.doIt(condition, SqlKeyword.EXISTS, () -> String.format("(%s)", existsSql));
    }

    @Override
    public Children notExists(boolean condition, String notExistsSql) {
        return (Children)((AbstractWrapper)this.not(condition)).exists(condition, notExistsSql);
    }

    @Override
    public Children isNull(boolean condition, R column) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IS_NULL);
    }

    @Override
    public Children isNotNull(boolean condition, R column) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IS_NOT_NULL);
    }

    @Override
    public Children in(boolean condition, R column, Collection<?> coll) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IN, this.inExpression(coll));
    }

    @Override
    public Children notIn(boolean condition, R column, Collection<?> coll) {
        return (Children)((AbstractWrapper)this.not(condition)).in(condition, (Object)column, (Collection)coll);
    }

    @Override
    public Children inSql(boolean condition, R column, String inValue) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IN, () -> String.format("(%s)", inValue));
    }

    @Override
    public Children notInSql(boolean condition, R column, String inValue) {
        return (Children)((AbstractWrapper)this.not(condition)).inSql(condition, (Object)column, inValue);
    }

    @Override
    public Children groupBy(boolean condition, R ... columns) {
        if (ArrayUtils.isEmpty(columns)) {
            return this.typedThis;
        }
        return this.doIt(condition, SqlKeyword.GROUP_BY, () -> columns.length == 1 ? this.columnToString(columns[0]) : this.columnsToString(columns));
    }

    @Override
    public Children orderBy(boolean condition, boolean isAsc, R ... columns) {
        if (ArrayUtils.isEmpty(columns)) {
            return this.typedThis;
        }
        SqlKeyword mode = isAsc ? SqlKeyword.ASC : SqlKeyword.DESC;
        for (R column : columns) {
            this.doIt(condition, SqlKeyword.ORDER_BY, () -> this.columnToString(column), mode);
        }
        return this.typedThis;
    }

    @Override
    public Children having(boolean condition, String sqlHaving, Object ... params) {
        return this.doIt(condition, SqlKeyword.HAVING, () -> this.formatSqlIfNeed(condition, sqlHaving, params));
    }

    protected Children not(boolean condition) {
        return this.doIt(condition, SqlKeyword.NOT);
    }

    protected Children and(boolean condition) {
        return this.doIt(condition, SqlKeyword.AND);
    }

    protected Children likeValue(boolean condition, R column, Object val, SqlLike sqlLike) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.LIKE, () -> this.formatSql("{0}", SqlUtils.concatLike(val, sqlLike)));
    }

    protected Children addCondition(boolean condition, R column, SqlKeyword sqlKeyword, Object val) {
        return this.doIt(condition, () -> this.columnToString(column), sqlKeyword, () -> this.formatSql("{0}", val));
    }

    protected Children addNestedCondition(boolean condition, Consumer<Children> consumer) {
        Children instance = this.instance();
        consumer.accept(instance);
        return this.doIt(condition, new ISqlSegment[]{WrapperKeyword.LEFT_BRACKET, instance, WrapperKeyword.RIGHT_BRACKET});
    }

    protected abstract Children instance();

    protected final String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected final String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isBlank(sqlStr)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty(params)) {
            for (int i = 0; i < params.length; ++i) {
                String genParamName = "MPGENVAL" + this.paramNameSeq.incrementAndGet();
                sqlStr = sqlStr.replace(String.format("{%s}", i), String.format("#{%s.paramNameValuePairs.%s}", "ew", genParamName));
                this.paramNameValuePairs.put(genParamName, params[i]);
            }
        }
        return sqlStr;
    }

    private ISqlSegment inExpression(Collection<?> value) {
        return () -> value.stream().map(i -> this.formatSql("{0}", i)).collect(Collectors.joining(",", "(", ")"));
    }

    protected final void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap<String, Object>(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
    }

    protected Children doIt(boolean condition, ISqlSegment ... sqlSegments) {
        if (condition) {
            this.expression.add(sqlSegments);
        }
        return this.typedThis;
    }

    @Override
    public String getSqlSegment() {
        String sqlSegment = this.expression.getSqlSegment();
        if (StringUtils.isNotBlank(sqlSegment)) {
            return sqlSegment + this.lastSql.getStringValue();
        }
        if (StringUtils.isNotBlank(this.lastSql.getStringValue())) {
            return this.lastSql.getStringValue();
        }
        return null;
    }

    @Override
    public String getSqlComment() {
        if (StringUtils.isNotBlank(this.sqlComment.getStringValue())) {
            return "/*" + StringEscape.escapeRawString(this.sqlComment.getStringValue()) + "*/";
        }
        return null;
    }

    @Override
    public MergeSegments getExpression() {
        return this.expression;
    }

    public Map<String, Object> getParamNameValuePairs() {
        return this.paramNameValuePairs;
    }

    protected String columnToString(R column) {
        if (column instanceof String) {
            return (String)column;
        }
        throw ExceptionUtils.mpe("not support this column !", new Object[0]);
    }

    protected String columnsToString(R ... columns) {
        return Arrays.stream(columns).map(this::columnToString).collect(Collectors.joining(","));
    }

    public Children clone() {
        return (Children)((AbstractWrapper)SerializationUtils.clone(this.typedThis));
    }
}

