/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.date.SafeDateFormat;

public final class DateUtil {
    private static final Map<String, SafeDateFormat> DATE_FORMATS = new ConcurrentHashMap<String, SafeDateFormat>();

    public static Date parse(String source, String df) {
        return DateUtil.parse(source, df, "GMT+8");
    }

    public static Date parse(String source, String df, String timeZone) {
        SafeDateFormat dateFormat = DateUtil.getDateFormat(df);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.parse(source);
    }

    private static SafeDateFormat getDateFormat(String df) {
        SafeDateFormat previous;
        SafeDateFormat dateFormat = DATE_FORMATS.get(df);
        if (dateFormat == null && (previous = DATE_FORMATS.putIfAbsent(df, dateFormat = new SafeDateFormat(df))) != null) {
            dateFormat = previous;
        }
        return dateFormat;
    }

    public static Object toPattern(String df) {
        SafeDateFormat dateFormat = DateUtil.getDateFormat(df);
        return dateFormat.toPattern();
    }

    public static String now(String df) {
        return DateUtil.getDateFormat(df).format(new Date());
    }

    public static boolean checkTimeZone(String timeZone) {
        String DEFAULT_GMT_TIMEZONE = "GMT";
        if (timeZone.equals("GMT")) {
            return true;
        }
        String id = TimeZone.getTimeZone(timeZone).getID();
        return !id.equals("GMT");
    }
}

