/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import java.io.File;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.config.OptionSpace;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.options.HubbleOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HubbleConfig {
    @Autowired
    private ApplicationArguments arguments;

    @Bean
    public HugeConfig hugeConfig() {
        String[] args = this.arguments.getSourceArgs();
        if (args.length > 1) {
            throw new ExternalException("HugeGraphHubble accept up to one param as config file", new Object[0]);
        }
        if (args.length == 0) {
            args = new String[]{"hugegraph-hubble.properties"};
        }
        OptionSpace.register((String)"hubble-be", (OptionHolder)HubbleOptions.instance());
        String conf = args[0];
        try {
            String path = HubbleConfig.class.getClassLoader().getResource(conf).getPath();
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                conf = path;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new HugeConfig(conf);
    }
}

