/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.algorithm;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.structure.Task;
import org.apache.hugegraph.util.PageUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsyncTaskService {
    private static final Logger log = LogManager.getLogger(AsyncTaskService.class);
    @Autowired
    private HugeClientPoolService poolService;

    private HugeClient getClient(int connId) {
        return this.poolService.getOrCreate(connId);
    }

    public Task get(int connId, int id) {
        HugeClient client = this.getClient(connId);
        return client.task().get((long)id);
    }

    public List<Task> list(int connId, List<Long> taskIds) {
        HugeClient client = this.getClient(connId);
        return client.task().list(taskIds);
    }

    public IPage<Task> list(int connId, int pageNo, int pageSize, String content, String type, String status) {
        HugeClient client = this.getClient(connId);
        if (status.isEmpty()) {
            status = null;
        }
        List tasks = client.task().list(status);
        ArrayList<Task> result = new ArrayList<Task>();
        for (Task task : tasks) {
            String taskId;
            if (!type.isEmpty() && !type.equals(task.type()) || !content.isEmpty() && !content.equals(taskId = String.valueOf(task.id())) && !task.name().contains(content)) continue;
            result.add(task);
        }
        result.sort(Comparator.comparing(Task::createTime).reversed());
        return PageUtil.page(result, pageNo, pageSize);
    }

    public void remove(int connId, int id) {
        HugeClient client = this.getClient(connId);
        client.task().delete((long)id);
    }

    public Task cancel(int connId, int id) {
        HugeClient client = this.getClient(connId);
        return client.task().cancel((long)id);
    }
}

