/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.occurrence;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nlpcn.commons.lang.occurrence.Count;
import org.nlpcn.commons.lang.occurrence.Element;
import org.nlpcn.commons.lang.util.CollectionUtil;
import org.nlpcn.commons.lang.util.MapCount;

public class Occurrence
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int seqId = 0;
    private Map<String, Count> word2Mc = new HashMap<String, Count>();
    private Map<Integer, String> idWordMap = new HashMap<Integer, String>();
    private MapCount<String> ww2Mc = new MapCount();
    private static final String CONN = "\u0000";

    public void addWords(Collection<String> words) {
        List<Element> all = this.makeCollection2EList(words);
        this.add(all);
    }

    private List<Element> makeCollection2EList(Collection<String> words) {
        ArrayList<Element> all = new ArrayList<Element>(words.size());
        for (String word : words) {
            all.add(new Element(word));
        }
        return all;
    }

    public void addColRow(Collection<String> rows, Collection<String> cols) {
        Count count = null;
        List<Element> colsList = this.makeCollection2EList(cols);
        List<Element> rowsList = this.makeCollection2EList(rows);
        for (Element word : colsList) {
            count = this.word2Mc.get(word.getName());
            if (count != null) {
                count.upScore();
                continue;
            }
            count = new Count(word.getNature(), this.seqId++);
            this.word2Mc.put(word.getName(), count);
            this.idWordMap.put(count.id, word.getName());
        }
        for (Element word : rowsList) {
            count = this.word2Mc.get(word.getName());
            if (count != null) {
                count.upScore();
                continue;
            }
            count = new Count(word.getNature(), this.seqId++);
            this.word2Mc.put(word.getName(), count);
            this.idWordMap.put(count.id, word.getName());
        }
        Element e1 = null;
        Element e2 = null;
        Count count1 = null;
        Count count2 = null;
        for (int i = 0; i < rowsList.size() - 1; ++i) {
            e1 = rowsList.get(i);
            count1 = this.word2Mc.get(e1.getName());
            for (int j = i + 1; j < colsList.size(); ++j) {
                e2 = colsList.get(j);
                count2 = this.word2Mc.get(e2.getName());
                if (count1.id == count2.id) continue;
                this.ww2Mc.add(e1.getName() + CONN + e2.getName());
                count1.upRelation(count2.id);
            }
        }
    }

    public void add(List<Element> words) {
        Count count = null;
        for (Element word : words) {
            count = this.word2Mc.get(word.getName());
            if (count != null) {
                count.upScore();
                continue;
            }
            count = new Count(word.getNature(), this.seqId++);
            this.word2Mc.put(word.getName(), count);
            this.idWordMap.put(count.id, word.getName());
        }
        Element e1 = null;
        Element e2 = null;
        Count count1 = null;
        Count count2 = null;
        for (int i = 0; i < words.size() - 1; ++i) {
            e1 = words.get(i);
            count1 = this.word2Mc.get(e1.getName());
            for (int j = i + 1; j < words.size(); ++j) {
                e2 = words.get(j);
                count2 = this.word2Mc.get(e2.getName());
                if (count1.id == count2.id) continue;
                if (count1.id < count2.id) {
                    this.ww2Mc.add(e1.getName() + CONN + e2.getName());
                } else {
                    this.ww2Mc.add(e2.getName() + CONN + e2.getName());
                }
                count1.upRelation(count2.id);
                count2.upRelation(count1.id);
            }
        }
    }

    public double distance(String word1, String word2) {
        Double distance = null;
        distance = this.ww2Mc.get().get(word1 + CONN + word2);
        if (distance != null) {
            return distance;
        }
        distance = this.ww2Mc.get().get(word2 + CONN + word1);
        if (distance != null) {
            return distance;
        }
        return 0.0;
    }

    public List<Map.Entry<String, Double>> distance(String word) {
        Count count = this.word2Mc.get(word);
        if (count == null) {
            return null;
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        String word2 = null;
        for (Integer id : count.relationSet) {
            word2 = this.idWordMap.get(id);
            map.put(word2, this.distance(word, word2) * this.word2Mc.get((Object)word2).score);
        }
        return CollectionUtil.sortMapByValue(map, 1);
    }

    public List<Map.Entry<String, Double>> distanceLogFreq1(String word) {
        Count count = this.word2Mc.get(word);
        if (count == null) {
            return null;
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        String word2 = null;
        for (Integer id : count.relationSet) {
            word2 = this.idWordMap.get(id);
            map.put(word2, Math.log(this.distance(word, word2) + 1.0) * this.word2Mc.get((Object)word2).score);
        }
        return CollectionUtil.sortMapByValue(map, 1);
    }

    public List<Map.Entry<String, Double>> distanceLogFreq(String word) {
        Count count = this.word2Mc.get(word);
        if (count == null) {
            return null;
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        String word2 = null;
        for (Integer id : count.relationSet) {
            word2 = this.idWordMap.get(id);
            map.put(word2, this.word2Mc.get((Object)word).score * Math.log(this.distance(word, word2) + 1.0) * this.word2Mc.get((Object)word2).score);
        }
        return CollectionUtil.sortMapByValue(map, 1);
    }

    public void computeTFIDF() {
        int size = this.word2Mc.size();
        Count count = null;
        for (Map.Entry<String, Count> element : this.word2Mc.entrySet()) {
            count = element.getValue();
            count.score = Math.log(((double)size + count.score) / count.score);
        }
    }

    public void saveModel(String filePath) throws IOException {
        ObjectOutputStream oot = new ObjectOutputStream(new FileOutputStream(filePath));
        oot.writeObject(this);
        oot.flush();
        oot.close();
    }

    public static Occurrence loadModel(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(filePath));
            Occurrence occurrence = (Occurrence)ois.readObject();
            return occurrence;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    public Map<String, Count> getWord2Mc() {
        return new HashMap<String, Count>(this.word2Mc);
    }
}

