/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class CharMatcher
extends AbstractMatcher {
    public final char character;

    public CharMatcher(char c) {
        super(CharMatcher.getLabel(c));
        this.character = c;
    }

    private static String getLabel(char c) {
        switch (c) {
            case '\ufdd0': 
            case '\ufdd1': 
            case '\ufdea': 
            case '\ufdeb': 
            case '\ufdec': 
            case '\ufded': 
            case '\ufdee': 
            case '\ufdef': 
            case '\uffff': {
                return StringUtils.escape(c);
            }
        }
        return '\'' + StringUtils.escape(c) + '\'';
    }

    public boolean match(MatcherContext matcherContext) {
        if (matcherContext.getCurrentChar() != this.character) {
            return false;
        }
        matcherContext.advanceIndex(1);
        matcherContext.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> matcherVisitor) {
        Preconditions.checkArgNotNull(matcherVisitor, "visitor");
        return matcherVisitor.visit(this);
    }
}

