/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class BackendSessionPool {
    private static final Logger LOG = Log.logger(BackendSessionPool.class);
    private final HugeConfig config;
    private final String name;
    private final ThreadLocal<BackendSession> threadLocalSession;
    private final AtomicInteger sessionCount;
    private final Map<Long, BackendSession> sessions;
    private final long reconnectDetectInterval;

    public BackendSessionPool(HugeConfig config, String name) {
        this.config = config;
        this.name = name;
        this.threadLocalSession = new ThreadLocal();
        this.sessionCount = new AtomicInteger(0);
        this.sessions = new ConcurrentHashMap<Long, BackendSession>();
        this.reconnectDetectInterval = (Long)this.config.get(CoreOptions.STORE_CONN_DETECT_INTERVAL);
    }

    public HugeConfig config() {
        return this.config;
    }

    public final BackendSession getOrNewSession() {
        BackendSession session = this.threadLocalSession.get();
        if (session == null) {
            session = this.newSession();
            assert (session != null);
            this.threadLocalSession.set(session);
            assert (!this.sessions.containsKey(Thread.currentThread().getId()));
            this.sessions.put(Thread.currentThread().getId(), session);
            int sessionCount = this.sessionCount.incrementAndGet();
            LOG.debug("Now(after connect({})) session count is: {}", (Object)this, (Object)sessionCount);
        } else {
            this.detectSession(session);
        }
        return session;
    }

    public BackendSession useSession() {
        BackendSession session = this.threadLocalSession.get();
        if (session != null) {
            session.attach();
            this.detectSession(session);
        } else {
            session = this.getOrNewSession();
        }
        return session;
    }

    private void detectSession(BackendSession session) {
        long interval = TimeUnit.SECONDS.toMillis(this.reconnectDetectInterval);
        long now = System.currentTimeMillis();
        if (now - session.updated() > interval) {
            session.reconnectIfNeeded();
        }
        session.update();
    }

    private Pair<Integer, Integer> closeSession() {
        int sessionCount = this.sessionCount.get();
        if (sessionCount <= 0) {
            assert (sessionCount == 0) : sessionCount;
            return Pair.of((Object)-1, (Object)-1);
        }
        assert (sessionCount > 0) : sessionCount;
        BackendSession session = this.threadLocalSession.get();
        if (session == null) {
            LOG.debug("Current session has ever been closed: {}", (Object)this);
            return Pair.of((Object)sessionCount, (Object)-1);
        }
        int ref = session.detach();
        assert (ref >= 0) : ref;
        if (ref > 0) {
            return Pair.of((Object)sessionCount, (Object)ref);
        }
        try {
            session.close();
        }
        catch (Throwable e) {
            session.attach();
            throw e;
        }
        this.threadLocalSession.remove();
        assert (this.sessions.containsKey(Thread.currentThread().getId()));
        this.sessions.remove(Thread.currentThread().getId());
        return Pair.of((Object)this.sessionCount.decrementAndGet(), (Object)ref);
    }

    public void forceResetSessions() {
        for (BackendSession session : this.sessions.values()) {
            session.reset();
        }
    }

    public boolean close() {
        Pair<Integer, Integer> result = Pair.of((Object)-1, (Object)-1);
        try {
            result = this.closeSession();
        }
        finally {
            if ((Integer)result.getLeft() == 0) {
                this.doClose();
            }
        }
        LOG.debug("Now(after close({})) session count is: {}, current session reference is: {}", new Object[]{this, result.getLeft(), result.getRight()});
        return (Integer)result.getLeft() == 0;
    }

    public boolean closed() {
        return this.sessionCount.get() == 0;
    }

    public String toString() {
        return String.format("%s-%s@%08X", this.name, this.getClass().getSimpleName(), this.hashCode());
    }

    public abstract void open() throws Exception;

    protected abstract boolean opened();

    public abstract BackendSession session();

    protected abstract BackendSession newSession();

    protected abstract void doClose();
}

