/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.tx;

import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.tx.AbstractTransaction;

public abstract class IndexableTransaction
extends AbstractTransaction {
    public IndexableTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
    }

    @Override
    public boolean hasUpdate() {
        AbstractTransaction indexTx = this.indexTransaction();
        boolean indexTxChanged = indexTx != null && indexTx.hasUpdate();
        return indexTxChanged || super.hasUpdate();
    }

    @Override
    protected void reset() {
        super.reset();
        AbstractTransaction indexTx = this.indexTransaction();
        if (indexTx != null) {
            indexTx.reset();
        }
    }

    @Override
    protected void commit2Backend() {
        BackendMutation mutation = this.prepareCommit();
        BackendMutation idxMutation = this.indexTransaction().prepareCommit();
        assert (!mutation.isEmpty() || !idxMutation.isEmpty());
        this.commitMutation2Backend(mutation, idxMutation);
    }

    @Override
    public void commitIfGtSize(int size) throws BackendException {
        int totalSize = this.mutationSize() + this.indexTransaction().mutationSize();
        if (totalSize >= size) {
            this.commit();
        }
    }

    @Override
    public void rollback() throws BackendException {
        try {
            super.rollback();
        }
        finally {
            this.indexTransaction().rollback();
        }
    }

    @Override
    public void close() {
        try {
            this.indexTransaction().close();
        }
        finally {
            super.close();
        }
    }

    protected abstract AbstractTransaction indexTransaction();
}

