/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.SingleWayMultiPathsRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.hugegraph.util.collection.IntIterator;

public class KneighborRecords
extends SingleWayMultiPathsRecords {
    public KneighborRecords(boolean concurrent, Id source, boolean nearest) {
        super(RecordType.INT, concurrent, source, nearest);
    }

    @Override
    public int size() {
        return (int)this.accessed();
    }

    @Override
    public List<Id> ids(long limit) {
        List<Id> ids = CollectionFactory.newList(CollectionType.EC);
        this.getRecords(limit, ids);
        return ids;
    }

    public Set<Id> idsBySet(long limit) {
        Set<Id> ids = CollectionFactory.newSet(CollectionType.EC);
        this.getRecords(limit, ids);
        return ids;
    }

    private void getRecords(long limit, Collection<Id> ids) {
        Stack<Record> records = this.records();
        for (int i = 1; i < records.size(); ++i) {
            IntIterator iterator = ((Record)records.get(i)).keys();
            while ((limit == -1L || limit > 0L) && iterator.hasNext()) {
                ids.add(this.id(iterator.next()));
                --limit;
            }
        }
    }

    @Override
    public HugeTraverser.PathSet paths(long limit) {
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        Stack<Record> records = this.records();
        for (int i = 1; i < records.size(); ++i) {
            IntIterator iterator = ((Record)records.get(i)).keys();
            while ((limit == -1L || limit > 0L) && iterator.hasNext()) {
                paths.add(this.linkPath(i, iterator.next()));
                --limit;
            }
        }
        return paths;
    }
}

