/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.CountTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/count")
@Singleton
@Tag(name="CountAPI")
public class CountAPI
extends API {
    private static final Logger LOG = Log.logger(CountAPI.class);

    @POST
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, CountRequest request) {
        LOG.debug("Graph [{}] get count from '{}' with request {}", (Object)graph, (Object)request);
        E.checkArgumentNotNull((Object)request.source, (String)"The source of request can't be null", (Object[])new Object[0]);
        Id sourceId = HugeVertex.getIdValue((Object)request.source);
        E.checkArgumentNotNull((Object)(request.steps != null && !request.steps.isEmpty() ? 1 : 0), (String)"The steps of request can't be null or empty", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)(request.dedupSize == -1L || request.dedupSize >= 0L ? 1 : 0), (String)"The dedup size of request must >= 0 or == -1, but got: '%s'", (Object[])new Object[]{request.dedupSize});
        HugeGraph g = CountAPI.graph(manager, graph);
        List<EdgeStep> steps = CountAPI.steps(g, request);
        CountTraverser traverser = new CountTraverser(g);
        long count = traverser.count(sourceId, steps, request.containsTraversed, request.dedupSize);
        return manager.serializer((Graph)g).writeMap((Map<?, ?>)ImmutableMap.of((Object)"count", (Object)count));
    }

    private static List<EdgeStep> steps(HugeGraph graph, CountRequest request) {
        int stepSize = request.steps.size();
        ArrayList<EdgeStep> steps = new ArrayList<EdgeStep>(stepSize);
        for (Step step : request.steps) {
            steps.add(step.jsonToStep(graph));
        }
        return steps;
    }

    private static class Step {
        @JsonProperty(value="direction")
        public Directions direction = Directions.BOTH;
        @JsonProperty(value="labels")
        public List<String> labels;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;
        @JsonAlias(value={"degree"})
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="skip_degree")
        public long skipDegree = Long.parseLong("100000");

        private Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,properties=%smaxDegree=%s,skipDegree=%s}", this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree);
        }

        private EdgeStep jsonToStep(HugeGraph graph) {
            return new EdgeStep(graph, this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree);
        }
    }

    private static class CountRequest {
        @JsonProperty(value="source")
        public Object source;
        @JsonProperty(value="steps")
        public List<Step> steps;
        @JsonProperty(value="contains_traversed")
        public boolean containsTraversed = false;
        @JsonProperty(value="dedup_size")
        public long dedupSize = 1000000L;

        private CountRequest() {
        }

        public String toString() {
            return String.format("CountRequest{source=%s,steps=%s,containsTraversed=%s,dedupSize=%s}", this.source, this.steps, this.containsTraversed, this.dedupSize);
        }
    }
}

