/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Seedable;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class CoinStep<S>
extends FilterStep<S>
implements Seedable {
    private final Random random = new Random();
    private final double probability;

    public CoinStep(Traversal.Admin traversal, double probability) {
        super(traversal);
        this.probability = probability;
    }

    @Override
    public void resetSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        long newBulk = 0L;
        if (traverser.bulk() < 100L) {
            int i = 0;
            while ((long)i < traverser.bulk()) {
                if (this.probability >= this.random.nextDouble()) {
                    ++newBulk;
                }
                ++i;
            }
        } else {
            newBulk = Math.round(this.probability * (double)traverser.bulk());
        }
        if (0L == newBulk) {
            return false;
        }
        traverser.setBulk(newBulk);
        return true;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.probability);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Double.hashCode(this.probability);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }
}

