/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.io.Storage;

public class TestSupport {
    public static final String TEST_DATA_RELATIVE_DIR = "test-case-data";

    protected TestSupport() {
    }

    public static File makeTestDataPath(Class<?> clazz, String ... childPath) {
        File root = TestSupport.getRootOfBuildDirectory(clazz);
        List cleanedPaths = Stream.of(childPath).map(TestSupport::cleanPathSegment).collect(Collectors.toList());
        cleanedPaths.add(0, TestSupport.cleanPathSegment(clazz.getSimpleName()));
        File f = new File(new File(root, TEST_DATA_RELATIVE_DIR), String.join((CharSequence)"/", cleanedPaths));
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static String makeTestDataDirectory(Class<?> clazz, String ... childPath) {
        return Storage.toPath(TestSupport.makeTestDataPath(clazz, childPath));
    }

    public static String makeTestDataFile(Class<?> clazz, String fileName) {
        return Storage.toPath(new File(TestSupport.makeTestDataPath(clazz, new String[0]), fileName));
    }

    public static String makeTestDataFile(Class<?> clazz, String subdir, String fileName) {
        return Storage.toPath(new File(TestSupport.makeTestDataPath(clazz, subdir), fileName));
    }

    public static File getRootOfBuildDirectory(Class<?> clazz) {
        File root;
        String buildDirectory = System.getProperty("build.dir");
        if (null == buildDirectory) {
            String clsUri = clazz.getName().replace(".", "/") + ".class";
            URL url = clazz.getClassLoader().getResource(clsUri);
            String clsPath = url.getPath();
            String computePath = clsPath.substring(0, clsPath.length() - clsUri.length());
            root = new File(computePath).getParentFile();
        } else {
            root = new File(buildDirectory);
        }
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File generateTempFile(Class<?> clazz, String fileName, String fileNameSuffix) throws IOException {
        File path = TestSupport.makeTestDataPath(clazz, "temp");
        if (!path.exists()) {
            path.mkdirs();
        }
        return File.createTempFile(fileName, fileNameSuffix, path);
    }

    public static File generateTempFileFromResource(Class<?> resourceClass, String resourceName, String extension) throws IOException {
        return TestSupport.generateTempFileFromResource(resourceClass, resourceClass, resourceName, extension);
    }

    public static File generateTempFileFromResource(Class<?> graphClass, Class<?> resourceClass, String resourceName, String extension) throws IOException {
        return TestSupport.generateTempFileFromResource(graphClass, resourceClass, resourceName, extension, true);
    }

    public static File generateTempFileFromResource(Class<?> graphClass, Class<?> resourceClass, String resourceName, String extension, boolean overwrite) throws IOException {
        File temp = TestSupport.makeTestDataPath(graphClass, "resources");
        File tempFile = new File(temp, resourceName + extension);
        if (tempFile.exists() && !overwrite) {
            return tempFile;
        }
        if (!tempFile.getParentFile().exists()) {
            Files.createDirectories(tempFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        Files.deleteIfExists(tempFile.toPath());
        Files.createFile(tempFile.toPath(), new FileAttribute[0]);
        try (FileOutputStream outputStream = new FileOutputStream(tempFile);
             InputStream inputStream = resourceClass.getResourceAsStream(resourceName);){
            int data;
            while ((data = inputStream.read()) != -1) {
                outputStream.write(data);
            }
        }
        return tempFile;
    }

    public static String cleanPathSegment(String toClean) {
        String cleaned = toClean.replaceAll("[.\\\\/:*?\"<>|\\[\\]\\(\\)]", "");
        if (cleaned.length() == 0) {
            throw new IllegalStateException("Path segment " + toClean + " has not valid characters and is thus empty");
        }
        return cleaned;
    }
}

