/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RpcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RpcUtils.class);
    public static final int MIN_RPC_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.rpc.closure.threadpool.size.min", Utils.cpus());
    public static final int MAX_RPC_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.rpc.closure.threadpool.size.max", Math.max(100, Utils.cpus() * 5));
    private static ThreadPoolExecutor RPC_CLOSURE_EXECUTOR = ThreadPoolUtil.newBuilder().poolName("JRAFT_RPC_CLOSURE_EXECUTOR").enableMetric(true).coreThreads(MIN_RPC_CLOSURE_EXECUTOR_POOL_SIZE).maximumThreads(MAX_RPC_CLOSURE_EXECUTOR_POOL_SIZE).keepAliveSeconds(60L).workQueue(new SynchronousQueue<Runnable>()).threadFactory(new NamedThreadFactory("JRaft-Rpc-Closure-Executor-", true)).build();

    public static Future<?> runClosureInThread(Closure done) {
        if (done == null) {
            return null;
        }
        return RpcUtils.runClosureInThread(done, Status.OK());
    }

    public static Future<?> runInThread(Runnable runnable) {
        return RPC_CLOSURE_EXECUTOR.submit(runnable);
    }

    public static Future<?> runClosureInThread(Closure done, Status status) {
        if (done == null) {
            return null;
        }
        return RpcUtils.runInThread(() -> {
            try {
                done.run(status);
            }
            catch (Throwable t) {
                LOG.error("Fail to run done closure.", t);
            }
        });
    }

    public static void runClosureInExecutor(Executor executor, Closure done, Status status) {
        if (done == null) {
            return;
        }
        if (executor == null) {
            RpcUtils.runClosureInThread(done, status);
            return;
        }
        executor.execute(() -> {
            try {
                done.run(status);
            }
            catch (Throwable t) {
                LOG.error("Fail to run done closure.", t);
            }
        });
    }

    private RpcUtils() {
    }
}

