/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.JsonPrettyGeneratorImpl;
import org.glassfish.json.JsonProviderImpl;

class JsonGeneratorFactoryImpl
implements JsonGeneratorFactory {
    private final boolean prettyPrinting;
    private final Map<String, Object> config;

    JsonGeneratorFactoryImpl(Map<String, ?> config) {
        this.prettyPrinting = config != null && JsonProviderImpl.isPrettyPrintingEnabled(config);
        HashMap<String, Boolean> providerConfig = new HashMap<String, Boolean>();
        if (this.prettyPrinting) {
            providerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        this.config = Collections.unmodifiableMap(providerConfig);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(writer) : new JsonGeneratorImpl(writer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(out) : new JsonGeneratorImpl(out);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        return this.prettyPrinting ? new JsonPrettyGeneratorImpl(out, charset) : new JsonGeneratorImpl(out, charset);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

