/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.profile;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.GraphReadMode;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs")
@Singleton
@Tag(name="GraphsAPI")
public class GraphsAPI
extends API {
    private static final Logger LOG = Log.logger(GraphsAPI.class);
    private static final String CONFIRM_CLEAR = "I'm sure to delete all data";
    private static final String CONFIRM_DROP = "I'm sure to drop the graph";

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$dynamic"})
    public Object list(@Context GraphManager manager, @Context SecurityContext sc) {
        Set<String> graphs = manager.graphs();
        HashSet<String> filterGraphs = new HashSet<String>();
        for (String graph : graphs) {
            String role = HugeAuthenticator.RequiredPerm.roleFor(graph, HugePermission.READ);
            if (!sc.isUserInRole(role)) continue;
            try {
                HugeGraph g = GraphsAPI.graph(manager, graph);
                filterGraphs.add(g.name());
            }
            catch (ForbiddenException forbiddenException) {}
        }
        return ImmutableMap.of((Object)"graphs", filterGraphs);
    }

    @GET
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$name"})
    public Object get(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Get graph by name '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, name);
        return ImmutableMap.of((Object)"name", (Object)g.name(), (Object)"backend", (Object)g.backend());
    }

    @DELETE
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public void drop(@Context GraphManager manager, @PathParam(value="name") String name, @QueryParam(value="confirm_message") String message) {
        LOG.debug("Drop graph by name '{}'", (Object)name);
        E.checkArgument((boolean)CONFIRM_DROP.equals(message), (String)"Please take the message: %s", (Object[])new Object[]{CONFIRM_DROP});
        manager.dropGraph(name);
    }

    @POST
    @Timed
    @Path(value="{name}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Object create(@Context GraphManager manager, @PathParam(value="name") String name, @QueryParam(value="clone_graph_name") String clone, String configText) {
        LOG.debug("Create graph '{}' with clone graph '{}', config text '{}'", new Object[]{name, clone, configText});
        HugeGraph graph = StringUtils.isNotEmpty((CharSequence)clone) ? manager.cloneGraph(clone, name, configText) : manager.createGraph(name, configText);
        return ImmutableMap.of((Object)"name", (Object)graph.name(), (Object)"backend", (Object)graph.backend());
    }

    @GET
    @Timed
    @Path(value="{name}/conf")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public File getConf(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Get graph configuration by name '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph4admin(manager, name);
        HugeConfig config = (HugeConfig)g.configuration();
        File file = config.file();
        if (file == null) {
            throw new NotSupportedException("Can't access the api in a node which started with non local file config.");
        }
        return file;
    }

    @DELETE
    @Timed
    @Path(value="{name}/clear")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"admin"})
    public void clear(@Context GraphManager manager, @PathParam(value="name") String name, @QueryParam(value="confirm_message") String message) {
        LOG.debug("Clear graph by name '{}'", (Object)name);
        E.checkArgument((boolean)CONFIRM_CLEAR.equals(message), (String)"Please take the message: %s", (Object[])new Object[]{CONFIRM_CLEAR});
        HugeGraph g = GraphsAPI.graph(manager, name);
        g.truncateBackend();
    }

    @PUT
    @Timed
    @Path(value="{name}/snapshot_create")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$name"})
    public Object createSnapshot(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Create snapshot for graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, name);
        g.createSnapshot();
        return ImmutableMap.of((Object)name, (Object)"snapshot_created");
    }

    @PUT
    @Timed
    @Path(value="{name}/snapshot_resume")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$name"})
    public Object resumeSnapshot(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Resume snapshot for graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, name);
        g.resumeSnapshot();
        return ImmutableMap.of((Object)name, (Object)"snapshot_resumed");
    }

    @PUT
    @Timed
    @Path(value="{name}/compact")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public String compact(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Manually compact graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, name);
        return JsonUtil.toJson((Object)g.metadata(null, "compact", new Object[0]));
    }

    @PUT
    @Timed
    @Path(value="{name}/mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$name"})
    public Map<String, GraphMode> mode(@Context GraphManager manager, @PathParam(value="name") String name, GraphMode mode) {
        LOG.debug("Set mode to: '{}' of graph '{}'", (Object)mode, (Object)name);
        E.checkArgument((mode != null ? 1 : 0) != 0, (String)"Graph mode can't be null", (Object[])new Object[0]);
        HugeGraph g = GraphsAPI.graph(manager, name);
        g.mode(mode);
        return ImmutableMap.of((Object)"mode", (Object)mode);
    }

    @GET
    @Timed
    @Path(value="{name}/mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$name"})
    public Map<String, GraphMode> mode(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Get mode of graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, name);
        return ImmutableMap.of((Object)"mode", (Object)g.mode());
    }

    @PUT
    @Timed
    @Path(value="{name}/graph_read_mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, GraphReadMode> graphReadMode(@Context GraphManager manager, @PathParam(value="name") String name, GraphReadMode readMode) {
        LOG.debug("Set graph-read-mode to: '{}' of graph '{}'", (Object)readMode, (Object)name);
        E.checkArgument((readMode != null ? 1 : 0) != 0, (String)"Graph-read-mode can't be null", (Object[])new Object[0]);
        HugeGraph g = GraphsAPI.graph(manager, name);
        g.readMode(readMode);
        return ImmutableMap.of((Object)"graph_read_mode", (Object)readMode);
    }

    @GET
    @Timed
    @Path(value="{name}/graph_read_mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$name"})
    public Map<String, GraphReadMode> graphReadMode(@Context GraphManager manager, @PathParam(value="name") String name) {
        LOG.debug("Get graph-read-mode of graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, name);
        return ImmutableMap.of((Object)"graph_read_mode", (Object)g.readMode());
    }
}

