/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class ServerOptions
extends OptionHolder {
    private static volatile ServerOptions instance;
    public static final ConfigOption<String> REST_SERVER_URL;
    public static final ConfigOption<String> SERVER_ID;
    public static final ConfigOption<String> SERVER_ROLE;
    public static final ConfigOption<Integer> MAX_WORKER_THREADS;
    public static final ConfigOption<Integer> MIN_FREE_MEMORY;
    public static final ConfigOption<Integer> REQUEST_TIMEOUT;
    public static final ConfigOption<Integer> CONN_IDLE_TIMEOUT;
    public static final ConfigOption<Integer> CONN_MAX_REQUESTS;
    public static final ConfigOption<String> GREMLIN_SERVER_URL;
    public static final ConfigOption<Integer> GREMLIN_SERVER_TIMEOUT;
    public static final ConfigOption<Integer> GREMLIN_SERVER_MAX_ROUTE;
    public static final ConfigOption<String> GRAPHS;
    public static final ConfigOption<Integer> MAX_VERTICES_PER_BATCH;
    public static final ConfigOption<Integer> MAX_EDGES_PER_BATCH;
    public static final ConfigOption<Integer> MAX_WRITE_RATIO;
    public static final ConfigOption<Integer> MAX_WRITE_THREADS;
    public static final ConfigOption<String> RAFT_GROUP_PEERS;
    public static final ConfigOption<Boolean> ALLOW_TRACE;
    public static final ConfigOption<String> AUTHENTICATOR;
    public static final ConfigOption<String> AUTH_GRAPH_STORE;
    public static final ConfigOption<String> AUTH_ADMIN_TOKEN;
    public static final ConfigListOption<String> AUTH_USER_TOKENS;
    public static final ConfigOption<String> AUTH_REMOTE_URL;
    public static final ConfigOption<String> SSL_KEYSTORE_FILE;
    public static final ConfigOption<String> SSL_KEYSTORE_PASSWORD;
    public static final ConfigOption<Boolean> ENABLE_DYNAMIC_CREATE_DROP;
    public static final ConfigOption<String> WHITE_IP_STATUS;
    public static final ConfigOption<String> ARTHAS_TELNET_PORT;
    public static final ConfigOption<String> ARTHAS_HTTP_PORT;
    public static final ConfigOption<String> ARTHAS_IP;
    public static final ConfigOption<String> ARTHAS_DISABLED_COMMANDS;
    public static final ConfigOption<Long> SLOW_QUERY_LOG_TIME_THRESHOLD;

    private ServerOptions() {
    }

    public static synchronized ServerOptions instance() {
        if (instance == null) {
            instance = new ServerOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        REST_SERVER_URL = new ConfigOption("restserver.url", "The url for listening of hugeserver.", OptionChecker.disallowEmpty(), (Object)"http://127.0.0.1:8080");
        SERVER_ID = new ConfigOption("server.id", "The id of hugegraph-server.", OptionChecker.disallowEmpty(), (Object)"server-1");
        SERVER_ROLE = new ConfigOption("server.role", "The role of nodes in the cluster, available types are [master, worker, computer]", OptionChecker.allowValues((Object[])new String[]{"master", "worker", "computer"}), (Object)"master");
        MAX_WORKER_THREADS = new ConfigOption("restserver.max_worker_threads", "The maximum worker threads of rest server.", OptionChecker.rangeInt((Number)2, (Number)Integer.MAX_VALUE), (Object)(2 * CoreOptions.CPUS));
        MIN_FREE_MEMORY = new ConfigOption("restserver.min_free_memory", "The minimum free memory(MB) of rest server, requests will be rejected when the available memory of system is lower than this value.", OptionChecker.nonNegativeInt(), (Object)64);
        REQUEST_TIMEOUT = new ConfigOption("restserver.request_timeout", "The time in seconds within which a request must complete, -1 means no timeout.", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)30);
        CONN_IDLE_TIMEOUT = new ConfigOption("restserver.connection_idle_timeout", "The time in seconds to keep an inactive connection alive, -1 means no timeout.", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)30);
        CONN_MAX_REQUESTS = new ConfigOption("restserver.connection_max_requests", "The max number of HTTP requests allowed to be processed on one keep-alive connection, -1 means unlimited.", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)256);
        GREMLIN_SERVER_URL = new ConfigOption("gremlinserver.url", "The url of gremlin server.", OptionChecker.disallowEmpty(), (Object)"http://127.0.0.1:8182");
        GREMLIN_SERVER_TIMEOUT = new ConfigOption("gremlinserver.timeout", "The timeout in seconds of waiting for gremlin server.", OptionChecker.positiveInt(), (Object)30);
        GREMLIN_SERVER_MAX_ROUTE = new ConfigOption("gremlinserver.max_route", "The max route number for gremlin server.", OptionChecker.positiveInt(), (Object)(2 * CoreOptions.CPUS));
        GRAPHS = new ConfigOption("graphs", "The directory store graphs' config file.", OptionChecker.disallowEmpty(), (Object)"./conf/graphs");
        MAX_VERTICES_PER_BATCH = new ConfigOption("batch.max_vertices_per_batch", "The maximum number of vertices submitted per batch.", OptionChecker.positiveInt(), (Object)500);
        MAX_EDGES_PER_BATCH = new ConfigOption("batch.max_edges_per_batch", "The maximum number of edges submitted per batch.", OptionChecker.positiveInt(), (Object)500);
        MAX_WRITE_RATIO = new ConfigOption("batch.max_write_ratio", "The maximum thread ratio for batch writing, only take effect if the batch.max_write_threads is 0.", OptionChecker.rangeInt((Number)0, (Number)100), (Object)50);
        MAX_WRITE_THREADS = new ConfigOption("batch.max_write_threads", "The maximum threads for batch writing, if the value is 0, the actual value will be set to batch.max_write_ratio * restserver.max_worker_threads.", OptionChecker.nonNegativeInt(), (Object)0);
        RAFT_GROUP_PEERS = new ConfigOption("raft.group_peers", "The rpc address of raft group initial peers.", OptionChecker.disallowEmpty(), (Object)"127.0.0.1:8090");
        ALLOW_TRACE = new ConfigOption("exception.allow_trace", "Whether to allow exception trace stack.", OptionChecker.disallowEmpty(), (Object)false);
        AUTHENTICATOR = new ConfigOption("auth.authenticator", "The class path of authenticator implementation. e.g., org.apache.hugegraph.auth.StandardAuthenticator, or org.apache.hugegraph.auth.ConfigAuthenticator.", null, (Object)"");
        AUTH_GRAPH_STORE = new ConfigOption("auth.graph_store", "The name of graph used to store authentication information, like users, only for org.apache.hugegraph.auth.StandardAuthenticator.", OptionChecker.disallowEmpty(), (Object)"hugegraph");
        AUTH_ADMIN_TOKEN = new ConfigOption("auth.admin_token", "Token for administrator operations, only for org.apache.hugegraph.auth.ConfigAuthenticator.", OptionChecker.disallowEmpty(), (Object)"162f7848-0b6d-4faf-b557-3a0797869c55");
        AUTH_USER_TOKENS = new ConfigListOption("auth.user_tokens", "The map of user tokens with name and password, only for org.apache.hugegraph.auth.ConfigAuthenticator.", OptionChecker.disallowEmpty(), (Object[])new String[]{"hugegraph:9fd95c9c-711b-415b-b85f-d4df46ba5c31"});
        AUTH_REMOTE_URL = new ConfigOption("auth.remote_url", "If the address is empty, it provide auth service, otherwise it is auth client and also provide auth service through rpc forwarding. The remote url can be set to multiple addresses, which are concat by ','.", null, (Object)"");
        SSL_KEYSTORE_FILE = new ConfigOption("ssl.keystore_file", "The path of server keystore file used when https protocol is enabled.", OptionChecker.disallowEmpty(), (Object)"conf/hugegraph-server.keystore");
        SSL_KEYSTORE_PASSWORD = new ConfigOption("ssl.keystore_password", "The password of the server keystore file when the https protocol is enabled.", null, (Object)"hugegraph");
        ENABLE_DYNAMIC_CREATE_DROP = new ConfigOption("graphs.enable_dynamic_create_drop", "Whether to enable create or drop graph dynamically.", OptionChecker.disallowEmpty(), (Object)true);
        WHITE_IP_STATUS = new ConfigOption("white_ip.status", "The status of whether enable white ip.", OptionChecker.disallowEmpty(), (Object)"disable");
        ARTHAS_TELNET_PORT = new ConfigOption("arthas.telnet_port", "The telnet port provided by Arthas, it can be accessible from the outside.", OptionChecker.disallowEmpty(), (Object)"8562");
        ARTHAS_HTTP_PORT = new ConfigOption("arthas.http_port", "The HTTP port provided by Arthas, it can be accessible from the outside.", OptionChecker.disallowEmpty(), (Object)"8561");
        ARTHAS_IP = new ConfigOption("arthas.ip", "The IP provided by Arthas, it can be accessible from the outside.", OptionChecker.disallowEmpty(), (Object)"127.0.0.1");
        ARTHAS_DISABLED_COMMANDS = new ConfigOption("arthas.disabled_commands", "The disabled Arthas commands due to high risk.", null, (Object)"jad");
        SLOW_QUERY_LOG_TIME_THRESHOLD = new ConfigOption("log.slow_query_threshold", "The threshold time(ms) of logging slow query, 0 means logging slow query is disabled.", OptionChecker.nonNegativeInt(), (Object)1000L);
    }
}

