/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.api.context;

import com.alipay.sofa.rpc.api.context.ResultCodeEnum;
import com.alipay.sofa.rpc.api.context.RpcReferenceContext;
import com.alipay.sofa.rpc.api.context.RpcServiceContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;

public class RpcContextManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RpcReferenceContext lastReferenceContext(boolean clear) {
        try {
            String resultCode;
            RpcInvokeContext invokeCtx = RpcInvokeContext.getContext();
            RpcReferenceContext referenceCtx = (RpcReferenceContext)invokeCtx.get("rpc.reference.ctx");
            if (referenceCtx != null && (resultCode = (String)invokeCtx.get("rpc.result.code")) != null) {
                referenceCtx.setResultCode(ResultCodeEnum.getResultCode(resultCode));
            }
            RpcReferenceContext rpcReferenceContext = referenceCtx;
            return rpcReferenceContext;
        }
        finally {
            if (clear) {
                RpcContextManager.clearReferenceContext();
            }
        }
    }

    public static RpcServiceContext currentServiceContext(boolean clear) {
        try {
            RpcInvokeContext invokeCtx = RpcInvokeContext.getContext();
            RpcServiceContext rpcServiceContext = (RpcServiceContext)invokeCtx.get("rpc.service.ctx");
            return rpcServiceContext;
        }
        finally {
            if (clear) {
                RpcContextManager.clearServiceContext();
            }
        }
    }

    public static void clearReferenceContext() {
        RpcInvokeContext.getContext().remove("rpc.reference.ctx");
    }

    public static void clearServiceContext() {
        RpcInvokeContext.getContext().remove("rpc.service.ctx");
    }

    public static void setReferenceContext(RpcReferenceContext referenceContext) {
        RpcInvokeContext.getContext().put("rpc.reference.ctx", referenceContext);
    }

    public static void setServiceContext(RpcServiceContext serviceContext) {
        RpcInvokeContext.getContext().put("rpc.service.ctx", serviceContext);
    }
}

